/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.AttrRef;
import condor.classad.ClassAdParser;
import condor.classad.Expr;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;

public class Query {
    private static String VERSION = "$Id: Query.java,v 1.11 2005/05/06 20:54:07 solomon Exp $";
    public final Expr[] selectClause;
    public final String[] selectNames;
    public String fromClause;
    public Expr whereClause;
    private static final AttrName SELECT = AttrName.fromString("select");
    private static final AttrName FROM = AttrName.fromString("from");
    private static final AttrName WHERE = AttrName.fromString("where");

    public Query(Expr[] s, String[] n, String f, Expr w) {
        boolean ok;
        boolean bl = ok = f != null && f.length() > 0;
        if (s == null) {
            ok = ok && n == null;
        } else {
            boolean bl2 = ok = ok && n != null && s.length == n.length;
        }
        if (!ok) {
            throw new IllegalArgumentException();
        }
        this.selectClause = s;
        this.selectNames = n;
        this.fromClause = f;
        this.whereClause = w;
    }

    public static Query parse(InputStream s) {
        return Query.parse(new ClassAdParser(s));
    }

    public static Query parse(Reader s) {
        return Query.parse(new ClassAdParser(s));
    }

    public static Query parse(String s) {
        return Query.parse(new ClassAdParser(s));
    }

    public static Query parse(ClassAdParser parser) {
        String[] ids;
        Expr[] exprs;
        Expr where;
        LinkedList<Expr> selectExprs = null;
        LinkedList<String> selectIds = null;
        Object v = parser.nextValue();
        if (v == null || !v.equals(SELECT)) {
            parser.printMessage("query must start with \"select\"");
            return null;
        }
        parser.getNextToken();
        if (parser.nextToken() == 42) {
            parser.getNextToken();
        } else {
            selectExprs = new LinkedList<Expr>();
            selectIds = new LinkedList<String>();
            while (true) {
                if (parser.nextToken() != 259) {
                    parser.printMessage("invalid \"select\" clause in query");
                    return null;
                }
                AttrName id = (AttrName)parser.nextValue();
                if (id.equals(FROM)) break;
                parser.getNextToken();
                if (parser.nextToken() == 61) {
                    parser.getNextToken();
                    Expr expr = parser.parse();
                    if (expr == null) {
                        parser.printMessage("invalid \"select\" clause in query");
                        return null;
                    }
                    selectIds.add(id.rawString());
                    selectExprs.add(expr);
                } else {
                    selectIds.add(null);
                    selectExprs.add(new AttrRef(id));
                }
                if (parser.nextToken() != 44) continue;
                parser.getNextToken();
            }
        }
        if (parser.nextToken() != 259 || !parser.nextValue().equals(FROM)) {
            parser.printMessage("missing \"from\" clause in query");
            return null;
        }
        parser.getNextToken();
        if (parser.nextToken() != 259) {
            parser.printMessage("invalid \"from\" clause in query");
            return null;
        }
        String from = ((AttrName)parser.nextValue()).rawString();
        parser.getNextToken();
        if (parser.nextToken() == 0) {
            where = null;
        } else {
            if (parser.nextToken() != 259 || !parser.nextValue().equals(WHERE)) {
                parser.printMessage("invalid \"where\" clause in query");
                return null;
            }
            parser.getNextToken();
            where = parser.parse();
            if (where == null) {
                parser.printMessage("invalid \"where\" clause in query");
                return null;
            }
        }
        if (selectExprs == null) {
            exprs = null;
            ids = null;
        } else {
            int n = selectExprs.size();
            Iterator ei = selectExprs.iterator();
            Iterator ii = selectIds.iterator();
            exprs = new Expr[n];
            ids = new String[n];
            for (int i = 0; i < n; ++i) {
                exprs[i] = (Expr)ei.next();
                ids[i] = (String)ii.next();
            }
        }
        return new Query(exprs, ids, from, where);
    }

    public String toString() {
        StringBuffer result;
        if (this.selectClause == null) {
            result = new StringBuffer("select *");
        } else {
            result = new StringBuffer("select ");
            for (int i = 0; i < this.selectClause.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                if (this.selectNames[i] != null) {
                    result.append(this.selectNames[i]).append(" = ");
                }
                result.append(this.selectClause[i]);
            }
        }
        result.append("\nfrom ").append(this.fromClause);
        if (this.whereClause != null) {
            result.append("\nwhere ").append(this.whereClause);
        }
        return result.toString();
    }
}

