/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RecordExpr
extends Expr {
    private static String VERSION = "$Id: RecordExpr.java,v 1.30 2005/09/30 18:34:36 solomon Exp $";
    private Map map;
    private List attrNames = new LinkedList();

    public RecordExpr() {
        super(-1);
        this.map = new HashMap();
    }

    public RecordExpr(int n) {
        super(-1);
        this.map = new HashMap(n, 1.0f);
    }

    protected String typeName() {
        return "classad";
    }

    public Expr lookup(String name) {
        return (Expr)this.map.get(AttrName.fromString(name));
    }

    public Expr lookup(AttrName name, Env env) {
        Expr res = (Expr)this.map.get(name);
        if (res == null) {
            res = env.search(name);
        }
        return res;
    }

    public Expr lookup(AttrName name) {
        return (Expr)this.map.get(name);
    }

    public RecordExpr insertAttribute(String name, Expr expr) {
        return this.insertAttribute(AttrName.fromString(name), expr);
    }

    public RecordExpr insertAttribute(AttrName key, Expr expr) {
        if (key == null) {
            throw new IllegalArgumentException("null attribute name " + key);
        }
        if (key == AttrName.PARENT) {
            throw new IllegalArgumentException("attribute name \"parent\" is reserved");
        }
        if (expr == null) {
            throw new IllegalArgumentException("null value for attribute " + key);
        }
        if (!this.map.containsKey(key)) {
            this.attrNames.add(key);
        }
        this.map.put(key, expr);
        return this;
    }

    public Expr removeAttribute(AttrName attr) {
        this.attrNames.remove(attr);
        return (Expr)this.map.remove(attr);
    }

    public int size() {
        return this.map.size();
    }

    public Iterator attributes() {
        return this.attrNames.iterator();
    }

    protected Expr eval1(Env env) {
        return this;
    }

    public StringBuffer toString(StringBuffer sb) {
        int sep = 91;
        Iterator keys = this.attrNames.iterator();
        while (keys.hasNext()) {
            AttrName name = (AttrName)keys.next();
            sb.append((char)sep).append(name).append('=');
            this.lookup(name).toString(sb);
            sep = 59;
        }
        if (sep == 91) {
            sb.append((char)sep);
        }
        return sb.append(']');
    }

    public boolean sameAs(Expr other) {
        Object[] keys2;
        if (this.type != other.type) {
            return false;
        }
        RecordExpr o = (RecordExpr)other;
        if (this.attrNames.size() != o.attrNames.size()) {
            return false;
        }
        Object[] keys1 = this.map.keySet().toArray();
        if (keys1.length != (keys2 = o.map.keySet().toArray()).length) {
            return false;
        }
        for (int i = 0; i < keys1.length; ++i) {
            Expr e2;
            Object k1 = keys1[i];
            Object k2 = keys2[i];
            if (!k1.equals(k2)) {
                return false;
            }
            Expr e1 = (Expr)this.map.get(k1);
            if (e1.sameAs(e2 = (Expr)o.map.get(k2))) continue;
            return false;
        }
        return true;
    }

    public void transmit(DataOutput out) throws IOException {
        Expr expr = this.lookup("MyType");
        if (expr == null) {
            throw new InvalidObjectException("no MyType attribute");
        }
        String myType = null;
        try {
            myType = ((Constant)expr).stringValue();
        }
        catch (Exception e) {
            throw new InvalidObjectException("bad MyType attribute: " + e);
        }
        expr = this.lookup("TargetType");
        if (expr == null) {
            throw new InvalidObjectException("no TargetType attribute");
        }
        String targetType = null;
        try {
            targetType = ((Constant)expr).stringValue();
        }
        catch (Exception e) {
            throw new InvalidObjectException("bad TargetType attribute: " + e);
        }
        out.writeInt(this.map.size() - 2);
        Iterator keys = this.attrNames.iterator();
        while (keys.hasNext()) {
            String name = keys.next().toString();
            if (name.equals("MyType") || name.equals("TargetType")) continue;
            Expr value = this.lookup(name);
            out.writeUTF(name + "=" + value.toString());
        }
        out.writeUTF(myType);
        out.writeUTF(targetType);
    }

    public int prec() {
        return 11;
    }
}

