/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.util.Iterator;

public class SelectExpr
extends Expr {
    private static String VERSION = "$Id: SelectExpr.java,v 1.26 2005/09/30 18:34:36 solomon Exp $";
    public final Expr base;
    public final AttrName selector;

    public SelectExpr(Expr base, String selector) {
        this(base, AttrName.fromString(selector));
    }

    public SelectExpr(Expr base, AttrName selector) {
        super(-5);
        this.base = base;
        this.selector = selector;
    }

    public static Expr select(Expr base, String[] sel) {
        for (int i = 0; i < sel.length; ++i) {
            base = new SelectExpr(base, AttrName.fromString(sel[i]));
        }
        return base;
    }

    protected String typeName() {
        return "selection";
    }

    public StringBuffer toString(StringBuffer sb) {
        return this.base.toString(sb).append('.').append(this.selector);
    }

    public boolean sameAs(Expr other) {
        if (this.type != other.type) {
            return false;
        }
        SelectExpr o = (SelectExpr)other;
        return this.selector.equals(o.selector) && this.base.sameAs(o.base);
    }

    public int prec() {
        return 12;
    }

    protected Expr eval1(Env env) {
        Expr result;
        Expr b = this.base.eval(env);
        if (b.type == 0 || b.type == 1) {
            result = b;
            env.clear();
        } else if (this.selector == AttrName.PARENT) {
            result = env.pop(1);
            if (result == null) {
                result = Constant.undefined("no parent");
                env.clear();
            }
        } else if (b.type == -1) {
            RecordExpr rec = (RecordExpr)b;
            result = rec.lookup(this.selector, env);
            if (result == null) {
                result = Constant.undefined("attribute " + this.selector + " not found in expression " + b);
                env.clear();
            } else {
                env.push(rec);
            }
        } else if (b.type == -2) {
            ListExpr l = new ListExpr();
            Iterator i = ((ListExpr)b).iterator();
            while (i.hasNext()) {
                Expr e = (Expr)i.next();
                l.add(new SelectExpr(e, this.selector).eval(new Env(env)));
            }
            result = l;
            env.clear();
        } else {
            env.clear();
            result = Constant.error(b + "." + this.selector + ": argument is not a record or list");
        }
        return result;
    }
}

