/*
 * Decompiled with CFR 0.152.
 */
package condor.classad;

import condor.classad.AttrName;
import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;

public class SubscriptExpr
extends Expr {
    private static String VERSION = "$Id: SubscriptExpr.java,v 1.20 2005/09/30 18:34:36 solomon Exp $";
    public final Expr base;
    public final Expr selector;

    public SubscriptExpr(Expr base, Expr selector) {
        super(-4);
        this.base = base;
        this.selector = selector;
    }

    protected String typeName() {
        return "subscript";
    }

    public StringBuffer toString(StringBuffer sb) {
        this.base.toString(sb).append('[');
        return this.selector.toString(sb).append(']');
    }

    public boolean sameAs(Expr other) {
        if (this.type != other.type) {
            return false;
        }
        SubscriptExpr o = (SubscriptExpr)other;
        return this.base.sameAs(o.base) && this.selector.sameAs(o.selector);
    }

    public int prec() {
        return 11;
    }

    protected Expr eval1(Env env) {
        Expr i = this.selector.eval(new Env(env));
        Expr b = this.base.eval(env);
        switch (b.type) {
            case -2: {
                if (i.type != 3) {
                    env.clear();
                    return Constant.error("List[" + i.typeName() + "]: type mismatch");
                }
                return ((ListExpr)b).sub(i.intValue());
            }
            case -1: {
                RecordExpr r = (RecordExpr)b;
                if (i.type != 5) {
                    env.clear();
                    return Constant.error("List[" + i.typeName() + "]: type mismatch");
                }
                Expr result = r.lookup(AttrName.fromString(i.stringValue()), env);
                if (result == null) {
                    result = Constant.undefined("attribute " + this.selector + " not found in expression " + b);
                    env.clear();
                } else {
                    env.push((RecordExpr)this.base);
                }
                return result;
            }
        }
        return Constant.error("[] applied to " + b.typeName());
    }
}

