/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import openbusidl.acs.Credential;
import openbusidl.acs.CredentialHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.interceptors.InterceptorImpl;
import tecgraf.openbus.util.Log;

class ClientInterceptor
extends InterceptorImpl
implements ClientRequestInterceptor {
    private ORB orb;
    private Openbus bus;
    private Credential credential;

    ClientInterceptor(Codec codec) {
        super("ClientInterceptor", codec);
    }

    public void send_request(ClientRequestInfo ri) {
        Log.INTERCEPTORS.info("Opera\u00e7\u00e3o {" + ri.operation() + "} interceptada no cliente.");
        if (this.bus == null) {
            this.bus = Openbus.getInstance();
            this.orb = this.bus.getORB();
        }
        this.credential = this.bus.getCredential();
        if (this.credential == null || this.credential.identifier.equals("")) {
            Log.INTERCEPTORS.info("SEM CREDENCIAL!");
            return;
        }
        Log.INTERCEPTORS.info("Credencial: " + this.credential.identifier + "," + this.credential.owner);
        byte[] value = null;
        try {
            Any credentialValue = this.orb.create_any();
            CredentialHelper.insert((Any)credentialValue, (Credential)this.credential);
            value = this.getCodec().encode_value(credentialValue);
        }
        catch (Exception e) {
            Log.INTERCEPTORS.severe("ERRO NA CODIFICA\u00c7\u00c2O DA CREDENCIAL!", e);
            return;
        }
        ri.add_request_service_context(new ServiceContext(1234, value), false);
        Log.INTERCEPTORS.fine("INSERI CREDENCIAL!");
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) {
    }

    public void receive_other(ClientRequestInfo ri) {
    }
}

