package tecgraf.openbus.browser;

import javax.swing.SwingUtilities;

import tecgraf.openbus.browser.AsyncObservable.AsyncObserver;


/**
 * Convenincia para garantir que eventos disparados pelo {@link AsyncObservable}
 * sejam executados necessariamente na EDT.
 * 
 * Extenda esta classe para criar cdigo que atualiza a interface Swing.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public abstract class AsyncSwingObserver implements AsyncObserver {

	public abstract void eventInEDT(AsyncObservable src);

	@Override
	public final void event(final AsyncObservable src) {
		if (SwingUtilities.isEventDispatchThread())
			eventInEDT(src);
		else
			SwingUtilities.invokeLater(new Runnable() {
				@Override
				public void run() {
					eventInEDT(src);
				}
			});
	}

}
