package tecgraf.openbus.browser;

import java.util.Observer;

import tecgraf.openbus.Connection;

/**
 * Interface que deve ser implementada por quem vai prover a conexo OpenBus
 * para os mdulos da aplicao.
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public interface ConnectionProvider {

	/**
	 * Retorna a conexo ativa, que deve ser usada para uma operao de chamada
	 * remota.
	 * @return A conexo a ser usada ou null se no houver nenhuma.
	 */
	public ManagedConnection getConnectionToUse();

	/**
	 * Resolve um bean de conexo baseado em sua conexo primitiva. til
	 * para identificar um bean de conexo informado pela API do OpenBus.
	 * @param primitiveConnection Uma conexo em seu formato bruto.
	 * @return Bean de conexo que encapsula a conexo informada ou null se no houver.
	 */
	public ManagedConnection getManagedConnectionOf(Connection primitiveConnection);

	/**
	 * Realizar a contagem de quantas so as conexes ativas para um dado busid.
	 * @param busID String que identifica o busid
	 * @return Contador de conexes ativas, conectadas e autenticadas.
	 */
	public int getNumActiveConnectionsOfBusID(String busID);

	/**
	 * Retorna uma conexo ativa para o busid informado. Em caso de ambiguidade,
	 * retorna a que foi mais recentemente usada como preferencial.
	 * @param busID String que identifica o busid.
	 * @return Referncia para a conexo ativa ou null se no houver nenhuma.
	 */
	public ManagedConnection getActiveConnectionsOfBusID(String busID);

	public void addObserver(Observer o);
	
	public void deleteObserver(Observer o);
	
}
