package tecgraf.openbus.browser.scs_offers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

/**
 * Interface a ser implementada por ns que podem receber outros ns
 * em uma ao de drag-and-drop.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public interface NodeWithDropBehaviorInterface {

	/**
	 * Pergunta sobre se o n em questo pode receber drops do tipo informado.
	 * @param dataFlavor Tipo de dado para o qual se deseja saber se pode dar drop.
	 * @return 0 para no aceito ou a ao aceita (vide {@link java.awt.dnd.DnDConstants})
	 */
	public int accept(DataFlavor dataFlavor);

	/**
	 * Executa o drop propriamente dito.
	 * @param t Dados do objeto que foi largado sobre o n.
	 * @return true se a operao foi bem sucedida.
	 * @throws Exception
	 */
	public boolean doDrop(Transferable t) throws Exception;

}
