package tecgraf.openbus.browser.scs_offers;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

/**
 * Extenso para o renderizador padro das linhas do JTree de resultados, responsvel
 * pela escolha do cone dos ns que implementam {@link NodeWithIconsInterface}.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
final class OfferTreeCellRenderer extends DefaultTreeCellRenderer implements TreeCellRenderer {

	@Override
	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf,
	  int row, boolean hasFocus) {
		JLabel res = (JLabel) super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
		NodeWithIconsInterface intf = null;
		if (value instanceof NodeWithIconsInterface)
			intf = (NodeWithIconsInterface) value;
		else if (value instanceof DefaultMutableTreeNode) {
			DefaultMutableTreeNode n = (DefaultMutableTreeNode) value;
			if (n.getUserObject() instanceof NodeWithIconsInterface) {
				intf = (NodeWithIconsInterface) n.getUserObject();
			}
		}
		if (intf != null) {
			Icon icon = null;
			if (leaf) {
				icon = intf.getLeafIcon();
			}
			else if (expanded) {
				icon = intf.getOpenedIcon();
			}
			else {
				icon = intf.getClosedIcon();
			}
			if (icon != null)
				res.setIcon(icon);
		}
		return res;
	}

}
