package tecgraf.openbus.browser.scs_offers;

import java.util.logging.Level;

import tecgraf.openbus.browser.AsyncObservable;
import tecgraf.openbus.browser.scs_offers.ServiceOfferRegistryObserversPool.BusObserverPoolBean;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferObserverSubscription;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;

/**
 * Bean que representa uma oferta de servio gerenciada internamente com seu
 * observador.
 * 
 * Uma instncia desta classe deve estar associada a um bean de
 * barramento {@link BusObserverPoolBean}.
 */
public final class ServiceOfferManagedBean extends AsyncObservable {

  private final ServiceOfferRegistryObserversPool serviceOfferRegistryObserversPool;
	final ServiceOffer serviceOffer;
	OfferObserverSubscription offerObserverSubscription;
	private final BusObserverPoolBean myPool;
	private volatile boolean removed = false;
	private volatile boolean invalid = false;
	private volatile boolean testing = false;

	public ServiceOfferManagedBean(ServiceOfferRegistryObserversPool serviceOfferRegistryObserversPool, BusObserverPoolBean myPool, ServiceOffer serviceOffer,
	  OfferObserverSubscription offerObserverSubscription) {
		super();
		this.serviceOfferRegistryObserversPool = serviceOfferRegistryObserversPool;
		this.serviceOffer = serviceOffer;
		this.offerObserverSubscription = offerObserverSubscription;
		this.myPool = myPool;
	}

	public void removeSubscriber() {
		try {
			synchronized (this) {
				if (offerObserverSubscription != null && myPool != null && myPool.busId != null) {
					this.serviceOfferRegistryObserversPool.connectionProvider.getActiveConnectionsOfBusID(myPool.busId).setContextCurrentConnection();
					ServiceOfferRegistryObserversPool.logger.fine("removeSubscriber(): Removendo listener de oferta.");
					offerObserverSubscription.remove();
					offerObserverSubscription = null;
				}
			}
		}
		catch (Throwable e) {
			ServiceOfferRegistryObserversPool.logger.log(Level.WARNING, "Exceo ignorada ao remover listener de oferta.", e);
		}
		synchronized (myPool.controlledBeans) {
			myPool.controlledBeans.remove(serviceOffer);
		}
	}

	@Override
	protected void finalize() throws Throwable {
		try {
			removeSubscriber();
		}
		catch (Throwable e) {
		}
		super.finalize();
	}

	protected void notifyChanged() {
		setChanged();
		notifyObservers();
	}

	protected void notifyRemoved() {
		removed = true;
		setChanged();
		notifyObservers();
	}

	protected void notifyInvalid() {
		invalid = true;
		setChanged();
		notifyObservers();
	}

	public boolean isRemoved() {
		return removed;
	}

	public boolean isInvalid() {
		return invalid;
	}

	public boolean isTesting() {
		return testing;
	}
	
	public void ping() {
		if (invalid || removed)
			return;
		
		testing = true;
		setChanged();
		notifyObservers();
		try{
		  if (serviceOffer._non_existent())
		  	removed = true;
		  if (serviceOffer.service_ref()._non_existent())
		  	invalid = true;
		}
		catch(Throwable e){
	  	invalid = true;
		}
		finally{
			testing = false;
			setChanged();
			notifyObservers();
		}
  }

}