package tecgraf.openbus.browser.scs_offers.basic_nodes;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import scs.core.ComponentId;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;

/**
 * Bean para popular o n da rvore que mostra um componente SCS.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public final class ComponentNodeBean implements NodeWithIconsInterface {

	private final ComponentId componentId;
	private final String label;

	public ComponentNodeBean(ComponentId componentId) {
		super();
		this.componentId = componentId;
		label = componentId.name;
	}

	/**
	 * @return the componentId
	 */
	public final ComponentId getComponentId() {
		return componentId;
	}

	@Override
	public String toString() {
		return label;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((label == null) ? 0 : label.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof ComponentNodeBean)) {
			return false;
		}
		ComponentNodeBean other = (ComponentNodeBean) obj;
		if (label == null) {
			if (other.label != null) {
				return false;
			}
		}
		else if (!label.equals(other.label)) {
			return false;
		}
		return true;
	}

	private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("plugin.png"));

	@Override
	public Icon getClosedIcon() {
		return icon;
	}

	@Override
	public Icon getLeafIcon() {
		return icon;
	}

	@Override
	public Icon getOpenedIcon() {
		return icon;
	}

}
