package tecgraf.openbus.browser.scs_offers.basic_nodes;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import scs.core.ComponentId;
import scs.core.IComponent;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;

/**
 * Bean para popular o n da rvore que mostra a verso do componente.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
public final class ComponentVersionNodeBean implements NodeWithIconsInterface {

	private final ComponentId componentId;
	private final IComponent component;
	private final String label;

	public ComponentVersionNodeBean(ComponentId componentId, IComponent component) {
		super();
		this.componentId = componentId;
		this.component = component;
		label = String.valueOf(componentId.major_version)
		  + "." + String.valueOf(componentId.minor_version)
		  + "." + String.valueOf(componentId.patch_version)
		  + (componentId.platform_spec.isEmpty() ? "" : ("(" + componentId.platform_spec + ")"));
	}

	/**
	 * @return the componentId
	 */
	public final ComponentId getComponentId() {
		return componentId;
	}

	/**
	 * @return the component
	 */
	public final IComponent getComponent() {
		return component;
	}

	@Override
	public String toString() {
		return label;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result =
		  prime * result + ((componentId == null) ? 0 : componentId.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof ComponentVersionNodeBean)) {
			return false;
		}
		ComponentVersionNodeBean other = (ComponentVersionNodeBean) obj;
		if (componentId == null) {
			if (other.componentId != null) {
				return false;
			}
		}
		else if (componentId.major_version != other.componentId.major_version) {
			return false;
		}
		else if (componentId.minor_version != other.componentId.minor_version) {
			return false;
		}
		else if (componentId.patch_version != other.componentId.patch_version) {
			return false;
		}
		else if (!componentId.name.equals(other.componentId.name)) {
			return false;
		}
		else if (!componentId.platform_spec.equals(other.componentId.platform_spec)) {
			return false;
		}
		return true;
	}

	private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("open_folder.png"));

	@Override
	public Icon getClosedIcon() {
		return icon;
	}

	@Override
	public Icon getLeafIcon() {
		return icon;
	}

	@Override
	public Icon getOpenedIcon() {
		return icon;
	}

}
