package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.Dimension;
import java.awt.Font;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import net.miginfocom.swing.MigLayout;

/**
 * Painel de detalhes que ser exibido quando o usurio selecionar um n
 * do tipo {@link ErrorNodeBean}.
 * <p>
 * O painel apenas exibe a pilha da exceo, como em {@link Throwable#printStackTrace()}.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
final class ErrorNodeDetailsPanel extends JPanel {

	public ErrorNodeDetailsPanel(Throwable myError) {
		super();

		setLayout(new MigLayout("", "[grow]", "[grow]"));
		setMinimumSize(new Dimension(0, 0));
		setPreferredSize(new Dimension(0, 0));

		JTextArea txtArea = new JTextArea();
		JScrollPane scrErrorText = new JScrollPane(txtArea);

		add(scrErrorText, "cell 0 0, grow");

		StringWriter errWriter = new StringWriter();
		myError.printStackTrace(new PrintWriter(errWriter));

		txtArea.setText(errWriter.toString());
		txtArea.setEditable(false);
		txtArea.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 10));

	}

}
