package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.scs_offers.FindServicesQueryControlInterface;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;

/**
 * Painel de detalhes que ser exibido para o usurio ao lado direito da rvore
 * de resultados da busca quando o n referente a uma oferta for selecionado.
 * <p>
 * O painel possui a lista das propriedades referentes  oferta.
 * 
 * @author Daltro Gama (daltro@tecgraf.puc-rio.br)
 */
@SuppressWarnings("serial")
final class ServiceOfferNodeDetailsPanel extends JPanel {

	private final ServiceOfferDesc offerDesc;
	private final JTable propTable;
	private final FindServicesQueryControlInterface queryControl;

	public ServiceOfferNodeDetailsPanel(FindServicesQueryControlInterface queryControl, ServiceOfferDesc offerDesc) {
		super();
		this.queryControl = queryControl;
		this.offerDesc = offerDesc;
		setLayout(new MigLayout("", "[grow]", "[grow]"));
		setMinimumSize(new Dimension(0, 0));
		setPreferredSize(new Dimension(0, 0));

		JScrollPane scrPropTable = new JScrollPane();
		add(scrPropTable, "cell 0 0,grow");

		propTable = new JTable();
		refresh();
		scrPropTable.setViewportView(propTable);

		propTable.addMouseListener(getPropTableMouseListener());

	}

	public void refresh() {
		propTable.setModel(new DefaultTableModel(
		  getPropertiesForTable(),
		  new String[] {
		      "Propriedade", "Valor"
		  }
		  ) {
			  Class<?>[] columnTypes = new Class[] {
			      String.class, String.class
			  };

			  @Override
			  public Class<?> getColumnClass(int columnIndex) {
				  return columnTypes[columnIndex];
			  }

			  boolean[] columnEditables = new boolean[] {
			      false, false
			  };

			  @Override
			  public boolean isCellEditable(int row, int column) {
				  return columnEditables[column];
			  }
		  });
	}

	private MouseListener getPropTableMouseListener() {
		return new MouseAdapter() {
			@Override
			public void mousePressed(MouseEvent e) {
				if (SwingUtilities.isRightMouseButton(e) && queryControl!=null) {
					if (propTable.getSelectedRows() == null || propTable.getSelectedRows().length == 0)
						return;

					JPopupMenu propertyPopup = new JPopupMenu();
					propertyPopup.add(getAddCriteriaItem(propTable.getSelectedRows()));

					propertyPopup.show(propTable, e.getX(), e.getY());
				}
			}
		};
	}

	protected JMenuItem getAddCriteriaItem(final int[] selectedRows) {
		JMenuItem res = new JMenuItem(
		  selectedRows.length == 1 ?
		    "Adicionar propriedade ao critrio" : "Adicionar propriedades ao critrio");
		res.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				for (int row : selectedRows) {
					int mRow;
					if (propTable.getRowSorter() != null)
						mRow = propTable.getRowSorter().convertRowIndexToModel(row);
					else
						mRow = row;
					queryControl.addCriteria(
					  propTable.getModel().getValueAt(mRow, 0).toString(),
					  propTable.getModel().getValueAt(mRow, 1).toString());
				}
			}
		});
		return res;
	}

	private Object[][] getPropertiesForTable() {
		Object[][] res = new Object[offerDesc.properties.length][];
		for (int i = 0; i < offerDesc.properties.length; i += 1) {
			res[i] = new Object[] {
			    offerDesc.properties[i].name,
			    offerDesc.properties[i].value
			};
		}
		return res;
	}

}
