/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.io.File;
import java.io.IOException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.SharedAuthSecret;
import tecgraf.openbus.browser.AsyncObservable;
import tecgraf.openbus.browser.AuthPanel;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.access_control.MissingCertificate;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.exception.InvalidLoginProcess;
import tecgraf.openbus.security.Cryptography;

public class ManagedConnection
extends AsyncObservable
implements Connection {
    private Connection myConnection = null;
    private Throwable lastError;
    private long lastErrorTimestamp;
    private final OpenBusContext openbusContext;
    private final AuthPanel.LoginType loginType;
    private final String host;
    private final int port;
    private final String entity;
    private final String password;
    private final RSAPrivateKey keyFile;
    private final File keyFilePath;
    private final AtomicInteger dispatchesToMeCounter = new AtomicInteger(0);
    private final CopyOnWriteArrayList<LogoffSyncListener> logoffListeners = new CopyOnWriteArrayList();
    private volatile ConnectionState state;
    private final InvalidLoginCallback myInvalidLoginCallback = new InvalidLoginCallback(){

        @Override
        public void invalidLogin(Connection arg0, LoginInfo arg1) {
            if (ManagedConnection.this.state == ConnectionState.ERROR) {
                System.out.println("Ignorando onInvalidLoginCallback por estar em erro.");
                return;
            }
            ManagedConnection.this.setStateWithNotify(ConnectionState.REAUTENTICATING);
            try {
                ManagedConnection.this.autenticate();
            }
            catch (AlreadyLoggedIn a) {
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                ManagedConnection.this.lastError = e;
                ManagedConnection.this.lastErrorTimestamp = System.currentTimeMillis();
                ManagedConnection.this.setStateWithNotify(ConnectionState.ERROR);
            }
        }
    };

    protected ManagedConnection(OpenBusContext openbusContext, String host, int port, String entity, String password) {
        this.state = ConnectionState.DISCONNECTED;
        this.openbusContext = openbusContext;
        this.loginType = AuthPanel.LoginType.PASSWORD;
        this.host = host;
        this.port = port;
        this.entity = entity;
        this.password = password;
        this.keyFile = null;
        this.keyFilePath = null;
    }

    protected ManagedConnection(OpenBusContext openbusContext, String host, int port, String entity, File keyFile) throws InvalidKeySpecException, CryptographyException, IOException {
        this.state = ConnectionState.DISCONNECTED;
        this.openbusContext = openbusContext;
        this.loginType = AuthPanel.LoginType.PRIVATE_KEY;
        this.host = host;
        this.port = port;
        this.entity = entity;
        this.password = null;
        this.keyFile = Cryptography.getInstance().readKeyFromFile(keyFile.getAbsolutePath());
        this.keyFilePath = keyFile;
    }

    public final void connect() {
        if (this.myConnection == null) {
            this.setStateWithNotify(ConnectionState.CONNECTING);
            this.myConnection = this.openbusContext.createConnection(this.host, this.port);
            this.myConnection.onInvalidLoginCallback(this.myInvalidLoginCallback);
            this.setStateWithNotify(ConnectionState.CONNECTED);
        }
    }

    private void setStateWithNotify(ConnectionState state) {
        this.state = state;
        this.setChanged();
        this.notifyObservers();
    }

    public final void autenticate() throws AccessDenied, AlreadyLoggedIn, ServiceFailure, MissingCertificate {
        this.connect();
        switch (this.loginType) {
            case PASSWORD: {
                this.loginByPassword(this.entity, this.password.getBytes());
                break;
            }
            case PRIVATE_KEY: {
                this.loginByCertificate(this.entity, this.keyFile);
            }
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void setLastError(Throwable lastError) {
        this.lastError = lastError;
    }

    public long getLastErrorTimestamp() {
        return this.lastErrorTimestamp;
    }

    public void setLastErrorTimestamp(long lastErrorTimestamp) {
        this.lastErrorTimestamp = lastErrorTimestamp;
    }

    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public String busid() {
        if (this.myConnection == null || this.myConnection.busid() == null) {
            return "N/A";
        }
        return this.myConnection.busid();
    }

    @Override
    public LoginInfo login() {
        if (this.myConnection == null) {
            return null;
        }
        return this.myConnection.login();
    }

    @Override
    public void loginByCertificate(String arg0, RSAPrivateKey arg1) throws AlreadyLoggedIn, AccessDenied, MissingCertificate, ServiceFailure {
        if (arg0 == null) {
            throw new IllegalArgumentException("loginByCertificate com entidade nula!!");
        }
        if (arg1 == null) {
            throw new IllegalArgumentException("loginByCertificate com PrivateKey nula!!");
        }
        if (this.state != ConnectionState.REAUTENTICATING) {
            this.setStateWithNotify(ConnectionState.AUTENTICATING);
        }
        try {
            this.myConnection.loginByCertificate(arg0, arg1);
            this.setStateWithNotify(ConnectionState.AUTENTICATED);
        }
        catch (AlreadyLoggedIn e) {
            this.setStateWithNotify(ConnectionState.AUTENTICATED);
            throw e;
        }
        catch (Throwable e) {
            this.lastError = e;
            this.lastErrorTimestamp = System.currentTimeMillis();
            this.setStateWithNotify(ConnectionState.ERROR);
        }
    }

    @Override
    public void loginByPassword(String arg0, byte[] arg1) throws AccessDenied, AlreadyLoggedIn, ServiceFailure {
        if (this.state != ConnectionState.REAUTENTICATING) {
            this.setStateWithNotify(ConnectionState.AUTENTICATING);
        }
        try {
            this.myConnection.loginByPassword(arg0, arg1);
            this.setStateWithNotify(ConnectionState.AUTENTICATED);
        }
        catch (AlreadyLoggedIn e) {
            this.setStateWithNotify(ConnectionState.AUTENTICATED);
            throw e;
        }
        catch (Throwable e) {
            this.lastError = e;
            this.lastErrorTimestamp = System.currentTimeMillis();
            this.setStateWithNotify(ConnectionState.ERROR);
        }
    }

    @Override
    public void loginBySharedAuth(SharedAuthSecret secret) throws AlreadyLoggedIn, InvalidLoginProcess, AccessDenied, ServiceFailure {
        if (this.state != ConnectionState.REAUTENTICATING) {
            this.setStateWithNotify(ConnectionState.AUTENTICATING);
        }
        try {
            this.myConnection.loginBySharedAuth(secret);
            this.setStateWithNotify(ConnectionState.AUTENTICATED);
        }
        catch (AlreadyLoggedIn e) {
            this.setStateWithNotify(ConnectionState.AUTENTICATED);
            throw e;
        }
        catch (Throwable e) {
            this.lastError = e;
            this.lastErrorTimestamp = System.currentTimeMillis();
            this.setStateWithNotify(ConnectionState.ERROR);
        }
    }

    @Override
    public boolean logout() throws ServiceFailure {
        this.setStateWithNotify(ConnectionState.DISCONNECTING);
        for (LogoffSyncListener listeners : this.logoffListeners) {
            listeners.preLogoff(this);
        }
        boolean res = this.myConnection.logout();
        this.setStateWithNotify(ConnectionState.DISCONNECTED);
        return res;
    }

    @Override
    public InvalidLoginCallback onInvalidLoginCallback() {
        return this.myConnection.onInvalidLoginCallback();
    }

    @Override
    public void onInvalidLoginCallback(InvalidLoginCallback arg0) {
        throw new IllegalAccessError("Tentativa indevida de trocar o onInvalidLoginCallback()!");
    }

    @Override
    public ORB orb() {
        return this.myConnection.orb();
    }

    @Override
    public SharedAuthSecret startSharedAuth() throws ServiceFailure {
        return this.myConnection.startSharedAuth();
    }

    public AuthPanel.LoginType getLoginType() {
        return this.loginType;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getEntity() {
        return this.entity;
    }

    public File getKeyFile() {
        return this.keyFilePath;
    }

    public void setContextCurrentConnection() {
        this.openbusContext.setCurrentConnection(this.myConnection);
    }

    public static void setContextCurrentConnection(Connection cnn) {
        if (cnn instanceof ManagedConnection) {
            ManagedConnection.getContext(cnn).setCurrentConnection(((ManagedConnection)cnn).getMyConnection());
        } else {
            ManagedConnection.getContext(cnn).setCurrentConnection(cnn);
        }
    }

    public void setDefaultContextConnection() {
        this.openbusContext.setDefaultConnection(this.myConnection);
    }

    public static void setDefaultContextConnection(Connection cnn) {
        if (cnn instanceof ManagedConnection) {
            ManagedConnection.getContext(cnn).setDefaultConnection(((ManagedConnection)cnn).getMyConnection());
        } else {
            ManagedConnection.getContext(cnn).setDefaultConnection(cnn);
        }
    }

    public static OpenBusContext getContext(Connection cnn) {
        try {
            return (OpenBusContext)((Object)cnn.orb().resolve_initial_references("OpenBusContext"));
        }
        catch (InvalidName e) {
            throw new IllegalStateException("Cad\u00ea o OpenBusContext?!?!", e);
        }
    }

    public OpenBusContext getContext() {
        return this.openbusContext;
    }

    public Connection getMyConnection() {
        return this.myConnection;
    }

    public void addLogoffSyncListener(LogoffSyncListener listener) {
        this.logoffListeners.add(listener);
    }

    public void clearLogoffSyncListener() {
        this.logoffListeners.clear();
    }

    public boolean removeLogoffSyncListener(LogoffSyncListener listener) {
        return this.logoffListeners.remove(listener);
    }

    public int getDispatchesToMeCounter() {
        return this.dispatchesToMeCounter.get();
    }

    public void incrementDispatchesToMeCounter() {
        this.dispatchesToMeCounter.incrementAndGet();
        this.setChanged();
        this.notifyObservers();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.loginType == null ? 0 : this.loginType.hashCode());
        result = 31 * result + (this.myConnection == null ? 0 : this.myConnection.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedConnection)) {
            return false;
        }
        ManagedConnection other = (ManagedConnection)obj;
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.loginType != other.loginType) {
            return false;
        }
        if (this.myConnection == null ? other.myConnection != null : !this.myConnection.equals(other.myConnection)) {
            return false;
        }
        return this.port == other.port;
    }

    public static interface LogoffSyncListener {
        public void preLogoff(ManagedConnection var1);
    }

    public static enum ConnectionState {
        DISCONNECTING,
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        AUTENTICATING,
        AUTENTICATED,
        REAUTENTICATING,
        ERROR;

    }
}

