/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.OpenbusBrowser;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;

public final class SlowRequester
extends JDialog {
    private static final int DIALOG_SHOW_DELAY = 2000;
    private static final ImageIcon IMG_TIME = new ImageIcon(OfferRegistryPanel.class.getResource("time-32.png"));
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final NumberFormat fmtNum = NumberFormat.getIntegerInstance();
    private final long initTimer;
    private final Thread executorThread;
    private Thread animatorThread = null;
    private final SlowRunnable runnable;
    private final JLabel lblTime;
    private final JLabel lblProgress;

    private SlowRequester(long initTimer, Thread executorThread, SlowRunnable runnable) {
        super((Window)OpenbusBrowser.getSingletonInstance(), Dialog.ModalityType.MODELESS);
        this.setTitle("Aguarde");
        this.setLocationRelativeTo(this.getOwner());
        this.initTimer = initTimer;
        this.executorThread = executorThread;
        this.runnable = runnable;
        this.setMinimumSize(new Dimension(300, 150));
        this.setResizable(true);
        this.getContentPane().setLayout(new MigLayout("", "[grow]", "[grow][][][][grow]"));
        this.lblProgress = new JLabel("Executando processamento lento");
        this.lblProgress.setMinimumSize(new Dimension(0, 0));
        this.getContentPane().add((Component)this.lblProgress, "cell 0 1,alignx center");
        this.lblTime = new JLabel("00:00:00.0", IMG_TIME, 0);
        this.lblTime.setMinimumSize(new Dimension(0, 0));
        this.lblTime.setFont(new Font("Monospaced", 1, 20));
        this.getContentPane().add((Component)this.lblTime, "cell 0 2,alignx center");
        JButton btnCancell = new JButton("Interromper");
        btnCancell.setToolTipText("Dar sinal interrupt() na thread do processamento.");
        this.getContentPane().add((Component)btnCancell, "cell 0 3,alignx center");
        btnCancell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlowRequester.this.executorThread.interrupt();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                this.closeAnimatorThread();
                SlowRequester.this.animatorThread = new AnimatorThread();
                SlowRequester.this.animatorThread.setDaemon(true);
                SlowRequester.this.animatorThread.setPriority(1);
                SlowRequester.this.animatorThread.start();
            }

            private void closeAnimatorThread() {
                if (SlowRequester.this.animatorThread != null && SlowRequester.this.animatorThread.isAlive()) {
                    SlowRequester.this.animatorThread.interrupt();
                }
                SlowRequester.this.animatorThread = null;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.closeAnimatorThread();
            }
        });
        this.pack();
    }

    private String getTime() {
        StringBuilder res = new StringBuilder();
        long time = System.currentTimeMillis() - this.initTimer;
        int hour = (int)(time / 3600000L);
        int minute = (int)((time -= (long)hour * 3600000L) / 60000L);
        int second = (int)((time -= (long)minute * 60000L) / 1000L);
        int deciSecond = (int)((time -= (long)second * 1000L) / 100L);
        res.append(fmtNum.format(hour));
        res.append(":");
        res.append(fmtNum.format(minute));
        res.append(":");
        res.append(fmtNum.format(second));
        res.append(".");
        res.append(deciSecond);
        return res.toString();
    }

    public static final void run(final SlowRunnable r, boolean async) {
        final Thread executorThread = new Thread(){

            @Override
            public void run() {
                try {
                    r.setException(null);
                    r.run();
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        return;
                    }
                    r.setException(e);
                }
            }
        };
        Runnable auxRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                executorThread.setDaemon(true);
                long timer = System.currentTimeMillis();
                final SlowRequester[] dialog = new SlowRequester[1];
                executorThread.start();
                try {
                    while (executorThread.isAlive()) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                            break;
                        }
                        long passedTime = System.currentTimeMillis() - timer;
                        if (passedTime <= 2000L || dialog[0] != null) continue;
                        dialog[0] = new SlowRequester(timer, executorThread, r);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dialog[0].setVisible(true);
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    if (dialog[0] != null) {
                        SwingUtilities.invokeLater(new Runnable(dialog){
                            final /* synthetic */ SlowRequester[] val$dialog;
                            {
                                this.val$dialog = slowRequesterArray;
                            }

                            @Override
                            public void run() {
                                this.val$dialog[0].setVisible(false);
                                this.val$dialog[0].dispose();
                            }
                        });
                    }
                    r.finish();
                    throw throwable;
                }
                if (dialog[0] != null) {
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                r.finish();
            }
        };
        if (async) {
            new Thread(auxRunnable).start();
        } else {
            auxRunnable.run();
        }
    }

    static {
        fmtNum.setMinimumFractionDigits(0);
        fmtNum.setMaximumFractionDigits(0);
        fmtNum.setMinimumIntegerDigits(2);
        fmtNum.setMaximumIntegerDigits(3);
    }

    private class AnimatorThread
    extends Thread {
        private AnimatorThread() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.sleep(100L);
                        if (!SlowRequester.this.isVisible()) continue;
                        final String time = SlowRequester.this.getTime();
                        final String title = SlowRequester.this.runnable.getTitle();
                        final String progress = SlowRequester.this.runnable.getProgress();
                        if (SlowRequester.this.getTitle().equals(title) && SlowRequester.this.lblProgress.getText().equals(progress) && SlowRequester.this.lblTime.getText().equals(time)) continue;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (!SlowRequester.this.getTitle().equals(title)) {
                                        SlowRequester.this.setTitle(title);
                                    }
                                    if (!SlowRequester.this.lblProgress.getText().equals(progress)) {
                                        SlowRequester.this.lblProgress.setText(progress);
                                    }
                                    if (!SlowRequester.this.lblTime.getText().equals(time)) {
                                        SlowRequester.this.lblTime.setText(time);
                                    }
                                }
                            });
                            continue block4;
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace(System.err);
                            break block4;
                        }
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public static abstract class SlowRunnable {
        private volatile String progress = "Executando processamento...";
        private volatile String title = "Aguarde";
        private volatile Throwable exception = null;

        public abstract void run() throws Exception;

        protected void setProgress(String progress) {
            if (progress == null) {
                progress = "";
            }
            this.progress = progress;
        }

        protected void setTitle(String title) {
            if (title == null) {
                title = "";
            }
            this.title = title;
        }

        public String getProgress() {
            return this.progress;
        }

        public String getTitle() {
            return this.title;
        }

        protected Throwable getException() {
            return this.exception;
        }

        protected void setException(Throwable exception) {
            this.exception = exception;
        }

        public void finish() {
            if (this.getException() != null) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), this.exception);
            }
        }
    }
}

