/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.SwingUncaughtExceptionHandlerItem;

class SwingUncaughtExceptionHandler
extends JDialog
implements Thread.UncaughtExceptionHandler {
    private JPanel exceptions;
    private final AtomicInteger errorCounter = new AtomicInteger(0);
    private JButton btnOk;

    public SwingUncaughtExceptionHandler() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    public SwingUncaughtExceptionHandler(Dialog owner) {
        super((Window)owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    public SwingUncaughtExceptionHandler(Frame owner) {
        super((Window)owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    public SwingUncaughtExceptionHandler(Window owner) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    private final void init() {
        this.setLayout(new MigLayout("", "[grow]", "[grow,fill][grow][center]"));
        this.setMinimumSize(new Dimension(600, 200));
        this.setPreferredSize(new Dimension(600, 200));
        JLabel title = new JLabel("Ocorreu uma exce\u00e7\u00e3o!");
        title.setIcon(new ImageIcon(this.getClass().getResource("login_error_32.png")));
        title.setFont(new Font("Dialog", 1, 16));
        this.add((Component)title, "cell 0 0");
        this.exceptions = new JPanel();
        this.exceptions.setLayout(new MigLayout("", "0[grow,fill]0"));
        JScrollPane scroll = new JScrollPane(this.exceptions);
        scroll.setBorder(null);
        this.btnOk = new JButton("Ok");
        this.btnOk.requestFocus();
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUncaughtExceptionHandler.this.setVisible(false);
                SwingUncaughtExceptionHandler.this.exceptions.removeAll();
                SwingUncaughtExceptionHandler.this.errorCounter.set(0);
            }
        });
        this.setDefaultCloseOperation(1);
        this.add((Component)scroll, "cell 0 1, grow");
        this.add((Component)this.btnOk, "cell 0 2, center");
        this.setAlwaysOnTop(true);
        SwingUncaughtExceptionHandler.setKeyListener(this, new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 8) {
                    e.consume();
                    SwingUncaughtExceptionHandler.this.btnOk.doClick();
                }
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent arg0) {
            }

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
                SwingUncaughtExceptionHandler.this.btnOk.requestFocus();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent arg0) {
                SwingUncaughtExceptionHandler.this.btnOk.requestFocus();
            }

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
                SwingUncaughtExceptionHandler.this.btnOk.requestFocus();
            }
        });
    }

    private static void setKeyListener(Component c, KeyListener l) {
        c.addKeyListener(l);
        if (c instanceof Container) {
            for (Component f : ((Container)c).getComponents()) {
                SwingUncaughtExceptionHandler.setKeyListener(f, l);
            }
        }
    }

    @Override
    public void uncaughtException(final Thread t, final Throwable e) {
        e.printStackTrace(System.err);
        try {
            Runnable shower = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SwingUncaughtExceptionHandler dialog;
                    SwingUncaughtExceptionHandler swingUncaughtExceptionHandler = dialog = SwingUncaughtExceptionHandler.this;
                    synchronized (swingUncaughtExceptionHandler) {
                        if (dialog.isVisible()) {
                            int counter = dialog.errorCounter.incrementAndGet();
                            if (counter <= 1) {
                                dialog.setTitle("ERRO");
                            } else if (counter > 1) {
                                dialog.setTitle(counter + " ERROS");
                            }
                            if (counter > 5) {
                                return;
                            }
                            JPanel div = new JPanel();
                            div.setMinimumSize(new Dimension(0, 5));
                            div.setMaximumSize(new Dimension(Integer.MAX_VALUE, 5));
                            div.setOpaque(true);
                            div.setBackground(Color.black);
                            SwingUncaughtExceptionHandler.this.exceptions.add((Component)div, "cell 0 0, flowy");
                            if (counter == 5) {
                                JLabel lblMore = new JLabel("As demais exce\u00e7\u00f5es est\u00e3o no log.");
                                SwingUncaughtExceptionHandler.this.exceptions.add((Component)lblMore, "cell 0 0, flowy");
                            } else if (counter < 5) {
                                SwingUncaughtExceptionHandler.this.exceptions.add((Component)new SwingUncaughtExceptionHandlerItem(e, t), "cell 0 0, flowy");
                            }
                        } else {
                            dialog.setTitle("ERRO");
                            dialog.errorCounter.set(1);
                            dialog.exceptions.removeAll();
                            dialog.exceptions.add((Component)new SwingUncaughtExceptionHandlerItem(e, t), "cell 0 0, flowy");
                            dialog.exceptions.invalidate();
                            dialog.exceptions.doLayout();
                            dialog.setLocationRelativeTo(dialog.getParent());
                            dialog.setVisible(true);
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                shower.run();
            } else {
                SwingUtilities.invokeAndWait(shower);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) throws IOException {
        final SwingUncaughtExceptionHandler handler = new SwingUncaughtExceptionHandler();
        int i = 0;
        while (i < 10) {
            final int k = i++;
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(k * 1000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    handler.uncaughtException(Thread.currentThread(), new RuntimeException("Deu ruim " + k + "!!", new RuntimeException("Deu ruim " + k + "!!", new RuntimeException("Deu ruim " + k + "!!", new NullPointerException()))));
                }
            }.start();
        }
        JOptionPane.showMessageDialog(null, "Oi!");
    }
}

