/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.TipPanelInterface;

public class TipPanel
extends JPanel
implements TipPanelInterface {
    private static final ImageIcon IMAGE_TIP = new ImageIcon(TipPanel.class.getResource("tip_32.png"));
    private static final ImageIcon IMAGE_TROLL = new ImageIcon(TipPanel.class.getResource("troll.png"));
    private static final ImageIcon IMAGE_LEFT = new ImageIcon(TipPanel.class.getResource("tip-left-16.png"));
    private static final ImageIcon IMAGE_RIGHT = new ImageIcon(TipPanel.class.getResource("tip-right-16.png"));
    private String[] tips;
    private String[] trolls;
    private boolean trollsEnabled = false;
    private int currentTip = 0;
    private final JTextPane tipArea;
    private final JLabel lblIcon;
    private final JLabel lblLeft;
    private final JLabel lblRight;

    public TipPanel() {
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 55));
        this.setMinimumSize(new Dimension(0, 55));
        this.setLayout(new MigLayout("", "0[32px:32px:32px,center][grow]0", "0[32px:32px:32px,center][grow,center]0"));
        this.lblIcon = new JLabel(IMAGE_TIP);
        this.lblIcon.setMinimumSize(new Dimension(32, 32));
        this.lblIcon.setMaximumSize(new Dimension(32, 32));
        this.add((Component)this.lblIcon, "flowy,cell 0 0");
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 1 0 1 2,grow");
        this.tipArea = new JTextPane();
        this.tipArea.setFont(new Font("Monospaced", 0, 10));
        this.tipArea.setMinimumSize(new Dimension(0, 0));
        this.tipArea.setEditable(false);
        this.tipArea.addKeyListener(new KeyAdapter(){
            ArrayList<Character> keyQueue = new ArrayList(6);

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() > 'a' && e.getKeyChar() < 'z') {
                    this.keyQueue.add(Character.valueOf(e.getKeyChar()));
                    if (this.keyQueue.size() > 5) {
                        this.keyQueue.remove(0);
                    }
                    if (Arrays.equals((Object[])this.keyQueue.toArray(new Character[0]), (Object[])new Character[]{Character.valueOf('t'), Character.valueOf('r'), Character.valueOf('o'), Character.valueOf('l'), Character.valueOf('l')})) {
                        TipPanel.this.getToolkit().beep();
                        TipPanel.this.trollsEnabled = true;
                        if (TipPanel.this.getNumTips() > 1) {
                            int newTip;
                            while ((newTip = (int)(System.currentTimeMillis() % (long)TipPanel.this.getNumTips())) == TipPanel.this.currentTip) {
                            }
                        }
                        TipPanel.this.showCurrentTip();
                    }
                }
            }
        });
        scrollPane.setViewportView(this.tipArea);
        this.lblLeft = TipPanel.getArrowLabel(IMAGE_LEFT);
        this.lblLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TipPanel.this.lblLeft.isEnabled()) {
                    return;
                }
                TipPanel.this.currentTip = TipPanel.this.currentTip - 1;
                if (TipPanel.this.currentTip == -1) {
                    TipPanel.this.currentTip = TipPanel.this.getNumTips() - 1;
                }
                TipPanel.this.showCurrentTip();
                e.consume();
            }
        });
        this.add((Component)this.lblLeft, "flowx,cell 0 1, center, gap 0");
        this.lblRight = TipPanel.getArrowLabel(IMAGE_RIGHT);
        this.lblRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TipPanel.this.lblRight.isEnabled()) {
                    return;
                }
                TipPanel.this.currentTip = (TipPanel.this.currentTip + 1) % TipPanel.this.getNumTips();
                TipPanel.this.showCurrentTip();
                e.consume();
            }
        });
        this.add((Component)this.lblRight, "cell 0 1, center, gap 0");
        this.setTips(null, null);
    }

    @Override
    public void setTips(String[] tips, String[] trolls) {
        if (tips == null) {
            tips = new String[]{};
        }
        if (trolls == null) {
            trolls = new String[]{};
        }
        if (Arrays.equals(this.tips, tips) && Arrays.equals(this.trolls, trolls)) {
            return;
        }
        this.tips = tips;
        this.trolls = trolls;
        this.trollsEnabled = tips == null || tips.length == 0 || System.currentTimeMillis() % 50L < 3L;
        this.currentTip = this.getNumTips() > 1 ? (int)(System.currentTimeMillis() % (long)this.getNumTips()) : 0;
        this.lblLeft.setEnabled(this.getNumTips() > 1);
        this.lblRight.setEnabled(this.getNumTips() > 1);
        this.showCurrentTip();
    }

    private final int getNumTips() {
        int nTrolls;
        int nTips = this.tips != null ? this.tips.length : 0;
        int n = nTrolls = this.trolls != null ? this.trolls.length : 0;
        if (this.trollsEnabled) {
            return nTips + nTrolls;
        }
        return nTips;
    }

    private final String getTip(int i) {
        if (this.tips != null && i < this.tips.length) {
            return this.tips[i];
        }
        if (this.trolls != null && this.trolls.length > 0) {
            return this.trolls[i - (this.tips != null ? this.tips.length : 0)];
        }
        return "";
    }

    private final boolean isTroll(int i) {
        return this.tips == null || i >= this.tips.length;
    }

    private void showCurrentTip() {
        String tip = this.getTip(this.currentTip);
        if (tip == null) {
            tip = "";
        }
        this.tipArea.setText(tip);
        if (!tip.equals("") && this.isTroll(this.currentTip) && this.lblIcon.getIcon() != IMAGE_TROLL) {
            this.lblIcon.setIcon(IMAGE_TROLL);
        } else if (this.lblIcon.getIcon() != IMAGE_TIP) {
            this.lblIcon.setIcon(IMAGE_TIP);
        }
        this.tipArea.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    private static final JLabel getArrowLabel(ImageIcon icon) {
        final JLabel res = new JLabel(icon);
        res.setMinimumSize(new Dimension(16, 16));
        res.setMaximumSize(new Dimension(16, 16));
        res.setFont(new Font("Monospaced", 0, 9));
        res.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (res.isEnabled()) {
                    res.setBorder(BorderFactory.createLineBorder(Color.blue));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (res.isEnabled()) {
                    res.setBorder(null);
                }
            }
        });
        return res;
    }
}

