/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.scs_offers.AsyncExpandableLoadingNodeBean;

final class AsyncExpandableLoadingDetailsPanel
extends JPanel {
    private static final ImageIcon IMG_TIME = new ImageIcon(AsyncExpandableLoadingDetailsPanel.class.getResource("time-32.png"));
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final NumberFormat fmtNum;
    private static volatile AsyncExpandableLoadingDetailsPanel animedInstance;
    private final AsyncExpandableLoadingNodeBean bean;
    private final JLabel lblTempo;

    public AsyncExpandableLoadingDetailsPanel(AsyncExpandableLoadingNodeBean argBean) {
        this.bean = argBean;
        this.setLayout(new MigLayout("", "[grow]", "[grow][][][grow]"));
        JLabel lblSatus = new JLabel(this.bean.getDescription());
        lblSatus.setMinimumSize(new Dimension(0, 0));
        this.add((Component)lblSatus, "cell 0 1,alignx center");
        this.lblTempo = new JLabel("00:00:00.0", IMG_TIME, 0);
        this.lblTempo.setMinimumSize(new Dimension(0, 0));
        this.lblTempo.setFont(new Font("Monospaced", 1, 20));
        this.add((Component)this.lblTempo, "cell 0 2,alignx center");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                animedInstance = null;
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                animedInstance = AsyncExpandableLoadingDetailsPanel.this;
            }
        });
    }

    private void updateTime() {
        StringBuilder res = new StringBuilder();
        long time = System.currentTimeMillis() - this.bean.getStartTimestamp();
        int hour = (int)(time / 3600000L);
        int minute = (int)((time -= (long)hour * 3600000L) / 60000L);
        int second = (int)((time -= (long)minute * 60000L) / 1000L);
        int deciSecond = (int)((time -= (long)second * 1000L) / 100L);
        res.append(fmtNum.format(hour));
        res.append(":");
        res.append(fmtNum.format(minute));
        res.append(":");
        res.append(fmtNum.format(second));
        res.append(".");
        res.append(deciSecond);
        String newVal = res.toString();
        if (!this.lblTempo.getText().equals(newVal)) {
            this.lblTempo.setText(newVal);
        }
    }

    static {
        animedInstance = null;
        fmtNum = NumberFormat.getIntegerInstance();
        fmtNum.setMinimumFractionDigits(0);
        fmtNum.setMaximumFractionDigits(0);
        fmtNum.setMinimumIntegerDigits(2);
        fmtNum.setMaximumIntegerDigits(3);
        CounterThread thread = new CounterThread();
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    private static final class CounterThread
    extends Thread {
        private CounterThread() {
        }

        @Override
        public void run() {
            try {
                if (!this.isInterrupted()) {
                    while (true) {
                        CounterThread.sleep(100L);
                        final AsyncExpandableLoadingDetailsPanel panel = animedInstance;
                        if (panel == null || !panel.isVisible()) continue;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    panel.updateTime();
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

