/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import tecgraf.openbus.browser.scs_offers.NodeWithDropBehaviorInterface;
import tecgraf.openbus.browser.scs_offers.SCSTree;

final class SCSTreeTransferHandle
extends TransferHandler {
    SCSTreeTransferHandle() {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        System.out.println("canImport " + support);
        JTree.DropLocation location = (JTree.DropLocation)support.getDropLocation();
        DefaultMutableTreeNode dest = (DefaultMutableTreeNode)location.getPath().getLastPathComponent();
        if (dest == null) {
            return false;
        }
        NodeWithDropBehaviorInterface droppable = null;
        if (dest instanceof NodeWithDropBehaviorInterface) {
            droppable = (NodeWithDropBehaviorInterface)((Object)dest);
        } else if (dest.getUserObject() instanceof NodeWithDropBehaviorInterface) {
            droppable = (NodeWithDropBehaviorInterface)dest.getUserObject();
        }
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (droppable.accept(flavor) == 0) continue;
            System.out.println("Aceitei " + flavor);
            return true;
        }
        System.out.println("N\u00e3o aceitei " + Arrays.toString(support.getDataFlavors()));
        return false;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        super.exportAsDrag(comp, e, action);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        System.out.println("exportToClipboard " + clip);
        super.exportToClipboard(comp, clip, action);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (!(c instanceof SCSTree)) {
            return null;
        }
        SCSTree scsTree = (SCSTree)c;
        if (scsTree.getSelectionPaths() == null) {
            return null;
        }
        return SCSTreeTransferHandle.getTransferable(scsTree.getSelectionPath());
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        System.out.println("getVisualRepresentation " + t);
        return super.getVisualRepresentation(t);
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (!(c instanceof SCSTree)) {
            return 0;
        }
        SCSTree scsTree = (SCSTree)c;
        if (scsTree.getSelectionPaths() == null) {
            return 0;
        }
        HashSet<DataFlavor> flavors = null;
        for (TreePath selection : scsTree.getSelectionPaths()) {
            Transferable t = SCSTreeTransferHandle.getTransferable(selection);
            if (t == null) {
                return 0;
            }
            if (flavors == null) {
                flavors = new HashSet<DataFlavor>(Arrays.asList(t.getTransferDataFlavors()));
                continue;
            }
            flavors.retainAll(Arrays.asList(t.getTransferDataFlavors()));
            if (!flavors.isEmpty()) continue;
            return 0;
        }
        return 3;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        System.out.println("canImport " + Arrays.toString(transferFlavors));
        return true;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (!(c instanceof SCSTree)) {
            return false;
        }
        SCSTree scsTree = (SCSTree)c;
        NodeWithDropBehaviorInterface droppable = SCSTreeTransferHandle.getDroppableNode(scsTree.getSelectionPath());
        if (droppable == null) {
            return false;
        }
        int accept = 0;
        for (DataFlavor flavor : t.getTransferDataFlavors()) {
            accept |= droppable.accept(flavor);
        }
        if (accept > 0) {
            try {
                droppable.doDrop(t);
                return true;
            }
            catch (Throwable e) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        return super.importData(support);
    }

    private static final Transferable getTransferable(TreePath path) {
        if (path == null) {
            return null;
        }
        if (path.getLastPathComponent() == null) {
            return null;
        }
        if (path.getLastPathComponent() instanceof Transferable) {
            return (Transferable)path.getLastPathComponent();
        }
        if (path.getLastPathComponent() instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (dmtn.getUserObject() == null) {
                return null;
            }
            if (dmtn.getUserObject() instanceof Transferable) {
                return (Transferable)dmtn.getUserObject();
            }
        }
        return null;
    }

    private static final NodeWithDropBehaviorInterface getDroppableNode(TreePath path) {
        if (path == null) {
            return null;
        }
        if (path.getLastPathComponent() == null) {
            return null;
        }
        if (path.getLastPathComponent() instanceof NodeWithDropBehaviorInterface) {
            return (NodeWithDropBehaviorInterface)path.getLastPathComponent();
        }
        if (path.getLastPathComponent() instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (dmtn.getUserObject() == null) {
                return null;
            }
            if (dmtn.getUserObject() instanceof NodeWithDropBehaviorInterface) {
                return (NodeWithDropBehaviorInterface)dmtn.getUserObject();
            }
        }
        return null;
    }
}

