/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import scs.core.ConnectionDescription;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.SlowRequester;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ReceptacleNodeBean;

final class ReceptacleNodeDetailsPanel
extends JPanel {
    private final ReceptacleNodeBean bean;
    private final JList list;
    private final Connection cnn;
    private JLabel lblName;
    private JLabel lblInterface;

    public ReceptacleNodeDetailsPanel(Connection cnn, ReceptacleNodeBean receptacleNodeBean) {
        this.cnn = cnn;
        this.bean = receptacleNodeBean;
        this.setLayout(new MigLayout("", "[grow]", "[][][grow]"));
        this.setMinimumSize(new Dimension(0, 0));
        this.lblName = new JLabel("Nome do recept\u00e1culo");
        this.lblName.setMinimumSize(new Dimension(0, 20));
        this.add((Component)this.lblName, "cell 0 0,growx");
        this.lblInterface = new JLabel("Interface do recept\u00e1culo");
        this.lblInterface.setFont(new Font("Monospaced", 0, 10));
        this.lblInterface.setMinimumSize(new Dimension(0, 16));
        this.add((Component)this.lblInterface, "cell 0 1,growx");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createTitledBorder("Conex\u00f5es"));
        this.add((Component)scrollPane, "cell 0 2,grow");
        this.list = new JList();
        this.list.setModel(new DefaultListModel());
        this.list.setBackground(UIManager.getColor("Window.background"));
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object[] selection;
                if (e.getKeyCode() == 127 && (selection = ReceptacleNodeDetailsPanel.this.list.getSelectedValues()) != null && selection.length > 0) {
                    String message = selection.length == 1 ? "Confirma uma desconex\u00e3o?" : "Confirma " + selection.length + " desconex\u00f5es?";
                    if (JOptionPane.showConfirmDialog(ReceptacleNodeDetailsPanel.this.getRootPane(), message, "Desconex\u00e3o", 0) == 1) {
                        return;
                    }
                    ReceptacleNodeDetailsPanel.this.doDisconnect(selection);
                    e.consume();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                final Object[] selection = ReceptacleNodeDetailsPanel.this.list.getSelectedValues();
                if (selection == null || selection.length == 0) {
                    return;
                }
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    e.consume();
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem disconnectItem = new JMenuItem("Desconectar");
                    menu.add(disconnectItem);
                    disconnectItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ReceptacleNodeDetailsPanel.this.doDisconnect(selection);
                        }
                    });
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        scrollPane.setViewportView(this.list);
        this.reloadConnectionList();
    }

    private void doDisconnect(final Object[] selection) {
        SlowRequester.run(new SlowRequester.SlowRunnable(){

            @Override
            public void run() throws Exception {
                ManagedConnection.setContextCurrentConnection(ReceptacleNodeDetailsPanel.this.cnn);
                for (Object o : selection) {
                    ReceptacleNodeDetailsPanel.this.bean.getIReceptacles().disconnect(((ConnectionItem)o).getReceptacleCnn().id);
                }
                ReceptacleNodeDetailsPanel.this.bean.refreshNode();
            }
        }, true);
    }

    public void reloadConnectionList() {
        ConnectionDescription[] cnns;
        this.lblName.setText(this.bean.getReceptacleDescription().name);
        this.lblInterface.setText(this.bean.getReceptacleDescription().interface_name);
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.clear();
        for (ConnectionDescription cnn : cnns = this.bean.getReceptacleDescription().connections) {
            model.addElement(new ConnectionItem(cnn));
        }
    }

    private final class ConnectionItem {
        private final ConnectionDescription receptacleCnn;
        private final String label;

        public ConnectionDescription getReceptacleCnn() {
            return this.receptacleCnn;
        }

        public ConnectionItem(ConnectionDescription receptacleCnn) {
            this.receptacleCnn = receptacleCnn;
            String host = "";
            try {
                ManagedConnection.setContextCurrentConnection(ReceptacleNodeDetailsPanel.this.cnn);
                ParsedIOR ior = new ParsedIOR((ORB)ReceptacleNodeDetailsPanel.this.cnn.orb(), receptacleCnn.objref.toString());
                IIOPProfile profile = (IIOPProfile)ior.getProfiles().get(0);
                String ip = ((IIOPAddress)profile.getAddress()).getIP();
                String hostname = ((IIOPAddress)profile.getAddress()).getHostname();
                if (hostname != null && !hostname.isEmpty() && !ip.equals(hostname)) {
                    ip = ip + "(" + hostname + ")";
                }
                host = " Host " + ip;
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            this.label = "[" + receptacleCnn.id + "]" + host;
        }

        public String toString() {
            return this.label;
        }
    }
}

