/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.AsyncObservable;
import tecgraf.openbus.browser.AsyncSwingObserver;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.SlowRequester;
import tecgraf.openbus.browser.TipPanelInterface;
import tecgraf.openbus.browser.scs_offers.FindServicesQueryControlInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithDetailsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithPopupMenuInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithSearchCapability;
import tecgraf.openbus.browser.scs_offers.NodeWithTreeReference;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;
import tecgraf.openbus.browser.scs_offers.RefreshableNode;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.ServiceOfferManagedBean;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ServiceOfferNodeDetailsPanel;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public final class ServiceOfferNode
extends NodeWithTreeReference
implements NodeWithDetailsInterface,
NodeWithIconsInterface,
RefreshableNode,
NodeWithPopupMenuInterface,
NodeWithHelpTipInterface,
NodeWithSearchCapability {
    private final ServiceOfferDesc serviceOffer;
    private String label;
    private final Connection cnn;
    private WeakReference<ServiceOfferNodeDetailsPanel> detailsPanel = null;
    private final FindServicesQueryControlInterface queryPropertiesInterface;
    private ServiceOfferManagedBean offerBean;
    private final AsyncObservable.AsyncObserver offerObserver = new AsyncSwingObserver(){

        @Override
        public void eventInEDT(AsyncObservable src) {
            if (ServiceOfferNode.this.getRoot() != ServiceOfferNode.this.getMyTree().getModel().getRoot()) {
                return;
            }
            ServiceOfferManagedBean offerBean = (ServiceOfferManagedBean)src;
            if (offerBean.isRemoved()) {
                ServiceOfferNode.this.getMyTree().removeOffer(ServiceOfferNode.this);
            } else {
                try {
                    ServiceOfferNode.this.label = ServiceOfferNode.this.buildLabel();
                    ((DefaultTreeModel)ServiceOfferNode.this.getMyTree().getModel()).nodeChanged(ServiceOfferNode.this);
                    if (offerBean.isInvalid()) {
                        ServiceOfferNode.this.removeAllChildren();
                        ((DefaultTreeModel)ServiceOfferNode.this.getMyTree().getModel()).nodeStructureChanged(ServiceOfferNode.this);
                    }
                    ((ServiceOfferNodeDetailsPanel)ServiceOfferNode.this.getDetailsPanel()).refresh();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    };
    private static final ImageIcon deadIcon = new ImageIcon(OfferRegistryPanel.class.getResource("scull.png"));
    private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("server.png"));

    public ServiceOfferNode(SCSTree tree, FindServicesQueryControlInterface queryPropertiesInterface, Connection cnn, ServiceOfferDesc serviceOffer) {
        super(tree);
        this.queryPropertiesInterface = queryPropertiesInterface;
        this.cnn = cnn;
        this.serviceOffer = serviceOffer;
        this.label = this.buildLabel();
    }

    @Override
    public void refreshNode() throws Exception {
        this.offerBean.ping();
    }

    public final ServiceOfferDesc getServiceOffer() {
        return this.serviceOffer;
    }

    public final String getLabel() {
        return this.label;
    }

    private String buildLabel() {
        if (this.offerBean != null && this.offerBean.isTesting()) {
            return "Testando oferta...";
        }
        TreeMap<String, String> propsMap = new TreeMap<String, String>();
        for (ServiceProperty prop : this.serviceOffer.properties) {
            propsMap.put(prop.name, prop.value);
        }
        String host = "";
        try {
            ManagedConnection.setContextCurrentConnection(this.cnn);
            ParsedIOR ior = new ParsedIOR((ORB)this.cnn.orb(), this.serviceOffer.service_ref.toString());
            IIOPProfile profile = (IIOPProfile)ior.getProfiles().get(0);
            String ip = ((IIOPAddress)profile.getAddress()).getIP();
            String hostname = ((IIOPAddress)profile.getAddress()).getHostname();
            if (hostname != null && !hostname.isEmpty() && !ip.equals(hostname)) {
                ip = ip + "(" + hostname + ")";
            }
            host = " do host " + ip;
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        StringBuilder res = new StringBuilder();
        if (this.offerBean != null && this.offerBean.isInvalid()) {
            res.append("Oferta [Inv\u00e1lida]");
        } else {
            res.append("Oferta" + host);
        }
        if (propsMap.containsKey("openbus.offer.entity")) {
            res.append(" (" + (String)propsMap.get("openbus.offer.entity") + ")");
        }
        if (propsMap.containsKey("openbus.offer.id")) {
            res.append(" - ID:" + (String)propsMap.get("openbus.offer.id"));
        }
        return res.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOfferNode)) {
            return false;
        }
        ServiceOfferNode other = (ServiceOfferNode)obj;
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }

    @Override
    public String toString() {
        return this.label;
    }

    @Override
    public JPanel getDetailsPanel() {
        ServiceOfferNodeDetailsPanel details = this.detailsPanel != null ? (ServiceOfferNodeDetailsPanel)this.detailsPanel.get() : null;
        if (details == null) {
            details = new ServiceOfferNodeDetailsPanel(this.queryPropertiesInterface, this.serviceOffer);
            this.detailsPanel = new WeakReference<ServiceOfferNodeDetailsPanel>(details);
        }
        return details;
    }

    public Icon getIcon() {
        boolean invalid = this.offerBean != null && this.offerBean.isInvalid();
        return invalid ? deadIcon : icon;
    }

    @Override
    public Icon getClosedIcon() {
        return this.getIcon();
    }

    @Override
    public Icon getLeafIcon() {
        return this.getIcon();
    }

    @Override
    public Icon getOpenedIcon() {
        return this.getIcon();
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu componentMenu = new JPopupMenu("Componente Ofertado");
        JMenuItem startupMenuItem = new JMenuItem("IComponent.startup()");
        startupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlowRequester.run(new SlowRequester.SlowRunnable(){

                    @Override
                    public void run() throws Exception {
                        ManagedConnection.setContextCurrentConnection(ServiceOfferNode.this.cnn);
                        ((ServiceOfferNode)ServiceOfferNode.this).serviceOffer.service_ref.startup();
                        JOptionPane.showMessageDialog(ServiceOfferNode.this.getMyTree(), "IComponent.startup() executado sem exce\u00e7\u00e3o.");
                    }

                    @Override
                    public void finish() {
                        if (this.getException() != null) {
                            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), this.getException());
                        } else {
                            JOptionPane.showMessageDialog(ServiceOfferNode.this.getMyTree(), "IComponent.startup() executado sem exce\u00e7\u00e3o.");
                        }
                    }
                }, true);
            }
        });
        componentMenu.add(startupMenuItem);
        JMenuItem shutdownMenuItem = new JMenuItem("IComponent.shutdown()");
        shutdownMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlowRequester.run(new SlowRequester.SlowRunnable(){

                    @Override
                    public void run() throws Exception {
                        ManagedConnection.setContextCurrentConnection(ServiceOfferNode.this.cnn);
                        ((ServiceOfferNode)ServiceOfferNode.this).serviceOffer.service_ref.shutdown();
                    }

                    @Override
                    public void finish() {
                        if (this.getException() != null) {
                            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), this.getException());
                        } else {
                            JOptionPane.showMessageDialog(ServiceOfferNode.this.getMyTree(), "IComponent.shutdown() executado sem exce\u00e7\u00e3o.");
                        }
                    }
                }, true);
            }
        });
        componentMenu.add(shutdownMenuItem);
        JMenuItem removeOfferMenuItem = new JMenuItem("ServiceOffer.remove()");
        removeOfferMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(ServiceOfferNode.this.getMyTree(), "Confirma remo\u00e7\u00e3o de oferta?", "Remo\u00e7\u00e3o de oferta", 0, 2) == 1) {
                    return;
                }
                SlowRequester.run(new SlowRequester.SlowRunnable(){

                    @Override
                    public void run() throws Exception {
                        ManagedConnection.setContextCurrentConnection(ServiceOfferNode.this.cnn);
                        ((ServiceOfferNode)ServiceOfferNode.this).serviceOffer.ref.remove();
                    }
                }, true);
            }
        });
        componentMenu.add(removeOfferMenuItem);
        return componentMenu;
    }

    @Override
    public void configureHelpTip(TipPanelInterface tipPanel) {
        tipPanel.setTips(new String[]{"Clique com o bot\u00e3o direito do mouse sobre a tabela de propriedades da oferta para pr\u00e9-configurar outra busca parametrizada ao servi\u00e7o de registros.", "Clique com o bot\u00e3o direito do mouse sobre o n\u00f3 para poder invocar os m\u00e9todos do ciclo de vida do componente IComponent.startup() e IComponent.shutdown().", "Clique com o bot\u00e3o direito do mouse sobre o n\u00f3 para poder remover a oferta atrav\u00e9s do ServiceOffer.remove()", "Para conectar a faceta a um recept\u00e1culo que a suporte, voc\u00ea pode arrastar o n\u00f3 da \u00e1rvore at\u00e9 um n\u00f3 do recept\u00e1culo desejado.", "Para conectar a faceta a um recept\u00e1culo, voc\u00ea pode \"copiar e colar\" o n\u00f3 da faceta no n\u00f3 do recept\u00e1culo."}, new String[]{"N\u00e3o d\u00ea shutdown em componentes de terceiros.", "N\u00e3o remova as ofertas dos coleguinhas sem avis\u00e1-los antes!"});
    }

    public void setOfferPoolBean(ServiceOfferManagedBean offerBean) {
        if (this.offerBean != null) {
            this.offerBean.removeObserver(this.offerObserver);
        }
        this.offerBean = offerBean;
        if (this.offerBean != null) {
            this.offerBean.addObserver(this.offerObserver);
        }
    }

    @Override
    public Object getUserObject() {
        return this;
    }

    @Override
    public boolean hasString(String lowerCaseStringToSearch) {
        for (ServiceProperty prop : this.serviceOffer.properties) {
            if (!prop.value.toLowerCase().contains(lowerCaseStringToSearch)) continue;
            return true;
        }
        return false;
    }
}

