/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.data_service;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jacorb.orb.ORB;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.scs_offers.AsyncExpandableTreeNode;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.basic_nodes.FacetNodeBean;
import tecgraf.openbus.browser.scs_offers.data_service.DataKeyNodeBean;
import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataService;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataServiceHelper;
import tecgraf.openbus.data_service.project.v1_01.ProjectDataViewFactory;
import tecgraf.openbus.data_service.project.v1_01.ProjectDataViewHelper;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewFactory;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewHelper;

public final class HDataServiceNodeBean
extends AsyncExpandableTreeNode
implements NodeWithIconsInterface {
    private final FacetNodeBean myFacetBean;
    private final Connection cnn;
    private static final AtomicBoolean valueFactoriesRegistered_DataService = new AtomicBoolean(false);
    private static final ImageIcon icon = new ImageIcon(HDataServiceNodeBean.class.getResource("hdataservice.png"));

    public HDataServiceNodeBean(SCSTree tree, Connection cnn, FacetNodeBean myFacetBean) {
        super(tree);
        this.myFacetBean = myFacetBean;
        this.cnn = cnn;
        if (!valueFactoriesRegistered_DataService.getAndSet(true)) {
            ORB orb = (ORB)cnn.orb();
            orb.register_value_factory(ProjectDataViewHelper.id(), new ProjectDataViewFactory());
            orb.register_value_factory(ProjectItemDataViewHelper.id(), new ProjectItemDataViewFactory());
        }
    }

    @Override
    protected String getLoadingDescription() {
        return "Aguardando retorno de IHierarchicalNavigationDataService.getRoots()...";
    }

    @Override
    protected List<DefaultMutableTreeNode> loadChildren() throws ServiceFailure, DataAccessDenied {
        ManagedConnection.setContextCurrentConnection(this.cnn);
        IHierarchicalNavigationDataService hdsn = IHierarchicalNavigationDataServiceHelper.narrow(this.myFacetBean.getFacetDescription().facet_ref);
        DataDescription[] roots = hdsn.getRoots();
        LinkedList<DefaultMutableTreeNode> res = new LinkedList<DefaultMutableTreeNode>();
        if (roots != null) {
            for (DataDescription ds : roots) {
                res.add(new DataKeyNodeBean(this.getMyTree(), this.cnn, this.myFacetBean, ds));
            }
        }
        return res;
    }

    @Override
    public Icon getClosedIcon() {
        return icon;
    }

    @Override
    public Icon getLeafIcon() {
        return icon;
    }

    @Override
    public Icon getOpenedIcon() {
        return icon;
    }
}

