/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_PERMISSIONHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;
import tecgraf.openbus.Connection;
import tecgraf.openbus.core.ChainCacheKey;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.EffectiveProfile;
import tecgraf.openbus.core.InterceptorImpl;
import tecgraf.openbus.core.LegacySupport;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.Session;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.CredentialHelper;
import tecgraf.openbus.core.v2_0.credential.CredentialData;
import tecgraf.openbus.core.v2_0.credential.CredentialDataHelper;
import tecgraf.openbus.core.v2_0.credential.CredentialReset;
import tecgraf.openbus.core.v2_0.credential.CredentialResetHelper;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.credential.SignedCallChainHelper;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfoHolder;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.security.Cryptography;

final class ClientRequestInterceptorImpl
extends InterceptorImpl
implements ClientRequestInterceptor {
    private static final Logger logger = Logger.getLogger(ClientRequestInterceptorImpl.class.getName());
    private Map<Integer, ConnectionImpl> requestId2Conn = Collections.synchronizedMap(new HashMap());
    private Map<Integer, String> requestId2LoginId = Collections.synchronizedMap(new HashMap());

    ClientRequestInterceptorImpl(String name, ORBMediator mediator) {
        super(name, mediator);
    }

    private boolean checkSlotIdFlag(ClientRequestInfo ri, int slotId) {
        try {
            Any any = ri.get_slot(slotId);
            if (any.type().kind().value() != 0) {
                return any.extract_boolean();
            }
            return false;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar slot";
            throw new INTERNAL(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_request(ClientRequestInfo ri) {
        ConnectionImpl conn;
        LoginInfo currLogin;
        Codec codec;
        ORB orb;
        ORBMediator mediator;
        String operation;
        block17: {
            operation = ri.operation();
            logger.finest(String.format("[in] send_request: %s", operation));
            try {
                mediator = this.mediator();
                orb = mediator.getORB();
                codec = mediator.getCodec();
                if (!this.checkSlotIdFlag(ri, this.context().getIgnoreThreadSlotId())) break block17;
                logger.finest(String.format("Realizando chamada fora do barramento: opera\u00e7\u00e3o (%s)", operation));
            }
            catch (Throwable throwable) {
                logger.finest(String.format("[out] send_request: %s", operation));
                throw throwable;
            }
            logger.finest(String.format("[out] send_request: %s", operation));
            return;
        }
        boolean joinedToLegacy = false;
        SignedCallChain joinedChain = this.getSignedChain(ri);
        if (Arrays.equals(joinedChain.signature, LegacySupport.LEGACY_ENCRYPTED_BLOCK)) {
            joinedToLegacy = true;
        }
        if ((currLogin = (conn = (ConnectionImpl)this.getCurrentConnection(ri)).getLogin()) == null) {
            String message = String.format("Chamada cancelada. Conex\u00e3o n\u00e3o possui login. opera\u00e7\u00e3o (%s)", operation);
            logger.info(message);
            throw new NO_PERMISSION(message, 1112888319, CompletionStatus.COMPLETED_NO);
        }
        LoginInfoHolder holder = new LoginInfoHolder();
        holder.value = currLogin;
        if (!joinedToLegacy) {
            byte[] encodedCredential;
            CredentialData credential = this.generateCredentialData(ri, conn, holder);
            Any anyCredential = orb.create_any();
            CredentialDataHelper.insert(anyCredential, credential);
            try {
                encodedCredential = codec.encode_value(anyCredential);
            }
            catch (InvalidTypeForEncoding e) {
                String message = "Falha ao codificar a credencial";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
            ServiceContext requestServiceContext = new ServiceContext(1112888064, encodedCredential);
            ri.add_request_service_context(requestServiceContext, false);
        }
        if (conn.legacy()) {
            String message;
            try {
                Credential legacyCredential = new Credential();
                legacyCredential.identifier = currLogin.id;
                legacyCredential.owner = currLogin.entity;
                String delegate = "";
                if (joinedChain != NULL_SIGNED_CALL_CHAIN) {
                    Any anyChain = codec.decode_value(joinedChain.encoded, CallChainHelper.type());
                    CallChain chain = CallChainHelper.extract(anyChain);
                    delegate = chain.originators != null && chain.originators.length > 0 && conn.isLegacyDelegateSetToOriginator() ? chain.originators[0].entity : chain.caller.entity;
                }
                legacyCredential.delegate = delegate;
                Any anyLegacy = orb.create_any();
                CredentialHelper.insert(anyLegacy, legacyCredential);
                byte[] encodedLegacy = codec.encode_value(anyLegacy);
                int legacyContextId = 1234;
                ServiceContext legacyServiceContext = new ServiceContext(legacyContextId, encodedLegacy);
                ri.add_request_service_context(legacyServiceContext, false);
            }
            catch (TypeMismatch e) {
                message = "Falha ao construir a credencial 1.5";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
            catch (FormatMismatch e) {
                message = "Falha ao construir a credencial 1.5";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
            catch (InvalidTypeForEncoding e) {
                message = "Falha ao codificar a credencial 1.5";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
        }
        if (joinedToLegacy && !conn.legacy()) {
            String message = "Imposs\u00edvel construir credencial: joined em cadeia 1.5 e sem suporte legacy";
            logger.severe(message);
            throw new NO_PERMISSION(message, 1112888065, CompletionStatus.COMPLETED_NO);
        }
        int uniqueId = mediator.getUniqueId();
        Any uniqueAny = orb.create_any();
        uniqueAny.insert_long(uniqueId);
        try {
            Current current = ORBUtils.getPICurrent(orb);
            current.set_slot(this.mediator().getRequestIdSlot(), uniqueAny);
            this.requestId2Conn.put(uniqueId, conn);
            this.requestId2LoginId.put(uniqueId, currLogin.id);
            logger.finest(String.format("associando o ID '%d' com o login '%s'. opera\u00e7\u00e3o (%s)", uniqueId, currLogin.id, ri.operation()));
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot de requestId";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        logger.finest(String.format("[out] send_request: %s", operation));
    }

    private CredentialData generateCredentialData(ClientRequestInfo ri, ConnectionImpl conn, LoginInfoHolder holder) {
        Session.ClientSideSession session;
        String operation = ri.operation();
        String busId = conn.busid();
        EffectiveProfile ep = new EffectiveProfile(ri.effective_profile());
        String target = conn.cache.entities.get(ep);
        if (target != null && (session = conn.cache.cltSessions.get(target)) != null) {
            int ticket = session.nextTicket();
            logger.finest(String.format("utilizando sess\u00e3o: id = %d ticket = %d", session.getSession(), ticket));
            byte[] secret = session.getSecret();
            byte[] credentialDataHash = this.generateCredentialDataHash(ri, secret, ticket);
            SignedCallChain chain = this.getCallChain(ri, conn, holder, target);
            logger.fine(String.format("Realizando chamada via barramento: target (%s) opera\u00e7\u00e3o (%s)", target, operation));
            return new CredentialData(busId, holder.value.id, session.getSession(), ticket, credentialDataHash, chain);
        }
        logger.finest(String.format("Realizando chamada sem credencial: login (%s) opera\u00e7\u00e3o (%s)", holder.value.id, operation));
        return new CredentialData(busId, holder.value.id, 0, 0, NULL_HASH_VALUE, NULL_SIGNED_CALL_CHAIN);
    }

    private SignedCallChain getCallChain(ClientRequestInfo ri, ConnectionImpl conn, LoginInfoHolder holder, String target) {
        SignedCallChain callChain;
        if (target.equals("00000000-0000-0000-0000-000000000000")) {
            callChain = this.getSignedChain(ri);
        } else {
            try {
                LoginInfo curr = holder.value;
                ChainCacheKey key = new ChainCacheKey(curr.id, target, this.getSignedChain(ri));
                callChain = conn.cache.chains.get(key);
                if (callChain == null) {
                    do {
                        callChain = conn.access().signChainFor(target);
                        curr = conn.getLogin();
                    } while (!this.unmarshallSignedChain((SignedCallChain)callChain, (Logger)ClientRequestInterceptorImpl.logger).caller.id.equals(curr.id));
                    conn.cache.chains.put(key, callChain);
                }
                holder.value = curr;
                logger.finest(String.format("definido o login '%s' para realizar a opera\u00e7\u00e3o (%s)", curr.id, ri.operation()));
            }
            catch (SystemException e) {
                String message = String.format("Erro durante acesso ao barramento (%s).", conn.busid());
                logger.log(Level.SEVERE, message, e);
                throw new NO_PERMISSION(message, 1112888317, CompletionStatus.COMPLETED_NO);
            }
            catch (InvalidLogins e) {
                Map<EffectiveProfile, String> cache = conn.cache.entities;
                ArrayList<EffectiveProfile> toRemove = new ArrayList<EffectiveProfile>();
                for (Map.Entry<EffectiveProfile, String> entry : cache.entrySet()) {
                    if (!target.equals(entry.getValue())) continue;
                    toRemove.add(entry.getKey());
                }
                for (EffectiveProfile ep : toRemove) {
                    cache.remove(ep);
                }
                String message = String.format("Erro ao assinar cadeia para target: (%s)", e.loginIds[0]);
                logger.log(Level.SEVERE, message, e);
                throw new NO_PERMISSION(message, 1112888316, CompletionStatus.COMPLETED_NO);
            }
            catch (ServiceFailure e) {
                String message = String.format("Falha inesperada ao assinar uma cadeia de chamadas para o target (%s)", target);
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
        }
        return callChain;
    }

    private SignedCallChain getSignedChain(ClientRequestInfo ri) {
        SignedCallChain callChain;
        try {
            Any any = ri.get_slot(this.mediator().getJoinedChainSlotId());
            callChain = any.type().kind().value() != 0 ? SignedCallChainHelper.extract(any) : NULL_SIGNED_CALL_CHAIN;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot do JoinedChain";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        return callChain;
    }

    @Override
    public void send_poll(ClientRequestInfo ri) {
        logger.finest(String.format("[inout] send_pool: %s", ri.operation()));
    }

    @Override
    public void receive_reply(ClientRequestInfo ri) {
        String operation = ri.operation();
        logger.finest(String.format("[in] receive_reply: %s", operation));
        if (!this.checkSlotIdFlag(ri, this.context().getIgnoreThreadSlotId())) {
            int uniqueId = this.getRequestUniqueId();
            this.requestId2Conn.remove(uniqueId);
            String login = this.requestId2LoginId.remove(uniqueId);
            this.clearRequestUniqueId();
            logger.finest(String.format("requisi\u00e7\u00e3o atendida com sucesso! ID (%d) login (%s) opera\u00e7\u00e3o (%s)", uniqueId, login, ri.operation()));
        }
        logger.finest(String.format("[out] receive_reply: %s", operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        String operation;
        block32: {
            NO_PERMISSION exception;
            Integer uniqueId;
            block30: {
                block31: {
                    block28: {
                        block29: {
                            operation = ri.operation();
                            logger.finest(String.format("[in] receive_exception: %s", operation));
                            uniqueId = null;
                            try {
                                logger.finest(String.format("Exception: %s Request: %s", ri.received_exception_id(), ri.operation()));
                                if (ri.received_exception_id().equals(NO_PERMISSIONHelper.id())) break block28;
                                if (uniqueId == null) break block29;
                                this.requestId2Conn.remove(uniqueId);
                            }
                            catch (Throwable throwable) {
                                if (uniqueId != null) {
                                    this.requestId2Conn.remove(uniqueId);
                                    this.requestId2LoginId.remove(uniqueId);
                                    this.clearRequestUniqueId();
                                }
                                logger.finest(String.format("[out] receive_exception: %s", operation));
                                throw throwable;
                            }
                            this.requestId2LoginId.remove(uniqueId);
                            this.clearRequestUniqueId();
                        }
                        logger.finest(String.format("[out] receive_exception: %s", operation));
                        return;
                    }
                    Any exceptionAny = ri.received_exception();
                    exception = NO_PERMISSIONHelper.extract(exceptionAny);
                    if (exception.completed.equals(CompletionStatus.COMPLETED_NO)) break block30;
                    if (uniqueId == null) break block31;
                    this.requestId2Conn.remove(uniqueId);
                    this.requestId2LoginId.remove(uniqueId);
                    this.clearRequestUniqueId();
                }
                logger.finest(String.format("[out] receive_exception: %s", operation));
                return;
            }
            uniqueId = this.getRequestUniqueId();
            ConnectionImpl conn = this.requestId2Conn.get(uniqueId);
            String loginId = this.requestId2LoginId.get(uniqueId);
            switch (exception.minor) {
                case 1112888064: {
                    byte[] secret;
                    EffectiveProfile ep = new EffectiveProfile(ri.effective_profile());
                    byte[] context_data = null;
                    try {
                        ServiceContext context = ri.get_reply_service_context(1112888064);
                        context_data = context.context_data;
                    }
                    catch (BAD_PARAM e) {
                        if (e.minor != 26) throw e;
                    }
                    if (context_data == null) {
                        String message = "Servidor n\u00e3o enviou o CredentialReset para negociar sess\u00e3o)";
                        logger.info(message);
                        throw new NO_PERMISSION(message, 1112888318, CompletionStatus.COMPLETED_NO);
                    }
                    Any credentialResetAny = null;
                    try {
                        credentialResetAny = this.mediator().getCodec().decode_value(context_data, CredentialResetHelper.type());
                    }
                    catch (FormatMismatch e) {
                        String message = "Falha inesperada ao obter o CredentialReset";
                        logger.log(Level.SEVERE, message, e);
                        throw new INTERNAL(message);
                    }
                    catch (TypeMismatch e) {
                        String message = "Falha inesperada ao obter o CredentialReset";
                        logger.log(Level.SEVERE, message, e);
                        throw new INTERNAL(message);
                    }
                    CredentialReset reset = CredentialResetHelper.extract(credentialResetAny);
                    String target = reset.target;
                    Cryptography crypto = Cryptography.getInstance();
                    try {
                        secret = crypto.decrypt(reset.challenge, conn.getPrivateKey());
                    }
                    catch (CryptographyException e) {
                        String message = "Falha inesperada ao descriptografar segredo.";
                        logger.log(Level.SEVERE, message, e);
                        throw new NO_PERMISSION(message, 1112888318, CompletionStatus.COMPLETED_NO);
                    }
                    conn.cache.entities.put(ep, target);
                    conn.cache.cltSessions.put(target, new Session.ClientSideSession(reset.session, secret, target));
                    logger.finest(String.format("ForwardRequest ap\u00f3s reset: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation()));
                    throw new ForwardRequest(ri.target());
                }
                case 1112888066: {
                    logger.finest(String.format("InvalidLogin: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation()));
                    boolean skipInvLogin = this.checkSlotIdFlag(ri, this.context().getSkipInvalidLoginSlotId());
                    if (skipInvLogin) break;
                    int validity = 0;
                    try {
                        this.context().ignoreInvLogin();
                        validity = this.context().getLoginRegistry().getLoginValidity(loginId);
                    }
                    catch (NO_PERMISSION e) {
                        if (e.minor != 1112888066) {
                            String msg = String.format("Erro em valida\u00e7\u00e3o de login: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation());
                            logger.log(Level.SEVERE, msg, e);
                            throw new NO_PERMISSION(msg, 1112888317, CompletionStatus.COMPLETED_NO);
                        }
                        LoginInfo curr = conn.login();
                        if (curr != null && curr.id.equals(loginId)) {
                            conn.localLogout(true);
                        }
                        logger.finest(String.format("ForwardRequest: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation()));
                        throw new ForwardRequest(ri.target());
                    }
                    catch (Exception e) {
                        String msg = String.format("Erro em valida\u00e7\u00e3o de login: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation());
                        logger.log(Level.SEVERE, msg, e);
                        throw new NO_PERMISSION(msg, 1112888317, CompletionStatus.COMPLETED_NO);
                    }
                    finally {
                        this.context().unignoreInvLogin();
                    }
                    if (validity > 0) {
                        String msg = String.format("InvalidLogin equivocado: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation());
                        logger.info(msg);
                        throw new NO_PERMISSION(msg, 1112888318, CompletionStatus.COMPLETED_NO);
                    }
                    logger.finest(String.format("ForwardRequest: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation()));
                    throw new ForwardRequest(ri.target());
                }
                case 1112888316: 
                case 1112888317: 
                case 1112888318: 
                case 1112888319: {
                    String message = "Servidor repassou uma exce\u00e7\u00e3o NO_PERMISSION local: minor = %d";
                    String msg = String.format(message, exception.minor);
                    logger.log(Level.WARNING, msg, exception);
                    throw new NO_PERMISSION(msg, 1112888318, CompletionStatus.COMPLETED_NO);
                }
                case 1112888070: {
                    break;
                }
            }
            if (uniqueId == null) break block32;
            this.requestId2Conn.remove(uniqueId);
            this.requestId2LoginId.remove(uniqueId);
            this.clearRequestUniqueId();
        }
        logger.finest(String.format("[out] receive_exception: %s", operation));
    }

    private int getRequestUniqueId() {
        int uniqueId;
        try {
            ORB orb = this.mediator().getORB();
            Current current = ORBUtils.getPICurrent(orb);
            Any uniqueAny = current.get_slot(this.mediator().getRequestIdSlot());
            if (uniqueAny.type().kind().value() == 0) {
                String message = "Any de chave \u00fanica de requestId est\u00e1 vazia!";
                logger.log(Level.SEVERE, message);
                throw new INTERNAL(message);
            }
            uniqueId = uniqueAny.extract_long();
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot do request Id";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        return uniqueId;
    }

    private void clearRequestUniqueId() {
        try {
            ORB orb = this.mediator().getORB();
            Any emptyAny = orb.create_any();
            Current current = ORBUtils.getPICurrent(orb);
            current.set_slot(this.mediator().getRequestIdSlot(), emptyAny);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de requestId";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }

    protected Connection getCurrentConnection(RequestInfo ri) {
        int id;
        Connection connection;
        Any any;
        OpenBusContextImpl context = this.mediator().getContext();
        try {
            any = ri.get_slot(context.getCurrentConnectionSlotId());
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot da conex\u00e3o corrente";
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0 && (connection = context.getConnectionById(id = any.extract_long())) != null) {
            return connection;
        }
        Connection connection2 = context.getDefaultConnection();
        if (connection2 != null) {
            return connection2;
        }
        throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
    }

    @Override
    public void receive_other(ClientRequestInfo ri) {
        logger.finest(String.format("[inout] receive_other: %s", ri.operation()));
    }
}

