/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.data_service.core.v1_01;

import java.util.LinkedList;
import org.omg.CORBA.SystemException;
import scs.core.IComponent;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.core.v1_05.registry_service.IRegistryService;
import tecgraf.openbus.core.v1_05.registry_service.Property;
import tecgraf.openbus.core.v1_05.registry_service.ServiceOffer;
import tecgraf.openbus.data_service.core.v1_01.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_01.IDataServiceHelper;
import tecgraf.openbus.data_service.core.v1_01.UnavailableDataService;

public final class DataServiceFinder {
    private static String DATA_SOURCE_ID_PROPERTY_NAME = "openbus.data_source_id";
    private static final String REGISTERED_BY_PROPERTY_NAME = "registered_by";

    public static IComponent find(DataKeyWrapper dataKey) throws UnavailableDataService {
        Openbus bus = Openbus.getInstance();
        LinkedList<Property> criteria = new LinkedList<Property>();
        String systemDeploymentId = dataKey.getSystemDeploymentId();
        criteria.add(new Property(REGISTERED_BY_PROPERTY_NAME, new String[]{systemDeploymentId}));
        String dataSourceId = dataKey.getDataSourceId();
        criteria.add(new Property(DATA_SOURCE_ID_PROPERTY_NAME, new String[]{dataSourceId}));
        String[] facets = new String[]{IDataServiceHelper.id()};
        IRegistryService registryService = bus.getRegistryService();
        ServiceOffer[] serviceOffer = registryService.findByCriteria(facets, criteria.toArray(new Property[0]));
        for (int i = 0; i < serviceOffer.length; ++i) {
            IComponent member = serviceOffer[i].member;
            if (!DataServiceFinder.isReachable(member)) continue;
            return member;
        }
        throw new UnavailableDataService();
    }

    private static boolean isReachable(IComponent component) {
        try {
            component.getComponentId();
            return true;
        }
        catch (SystemException e) {
            return false;
        }
    }
}

