/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.BusInfo;
import tecgraf.openbus.core.ChainCacheKey;
import tecgraf.openbus.core.EffectiveProfile;
import tecgraf.openbus.core.InternalLogin;
import tecgraf.openbus.core.IsValidCache;
import tecgraf.openbus.core.LRUCache;
import tecgraf.openbus.core.LeaseRenewer;
import tecgraf.openbus.core.LegacyInfo;
import tecgraf.openbus.core.LoginCache;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.OpenBusProperty;
import tecgraf.openbus.core.Session;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlService;
import tecgraf.openbus.core.v2_0.EncryptedBlockHolder;
import tecgraf.openbus.core.v2_0.OctetSeqHolder;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessControl;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidPublicKey;
import tecgraf.openbus.core.v2_0.services.access_control.LoginAuthenticationInfo;
import tecgraf.openbus.core.v2_0.services.access_control.LoginAuthenticationInfoHelper;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcess;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcessOperations;
import tecgraf.openbus.core.v2_0.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_0.services.access_control.MissingCertificate;
import tecgraf.openbus.core.v2_0.services.access_control.WrongEncoding;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.exception.InvalidLoginProcess;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.exception.OpenBusInternalException;
import tecgraf.openbus.security.Cryptography;

final class ConnectionImpl
implements Connection {
    private final String connId = UUID.randomUUID().toString();
    private static final Logger logger = Logger.getLogger(ConnectionImpl.class.getName());
    private Cryptography crypto;
    private ORB orb;
    private OpenBusContextImpl context;
    private BusInfo bus;
    private LegacyInfo legacyBus;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private InternalLogin internalLogin;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwlock.writeLock();
    private LeaseRenewer renewer;
    private InvalidLoginCallback invalidLoginCallback;
    Caches cache;
    private boolean legacy;
    private String delegate;

    public ConnectionImpl(String host, int port, OpenBusContextImpl manager, ORB orb) throws InvalidPropertyValue {
        this(host, port, manager, orb, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionImpl(String host, int port, OpenBusContextImpl context, ORB orb, Properties props) throws InvalidPropertyValue {
        String prop;
        Boolean disabled;
        if (host == null || host.isEmpty() || port < 0) {
            throw new IllegalArgumentException("Os parametros host e/ou port n\u00e3o s\u00e3o validos");
        }
        this.orb = orb;
        this.context = context;
        this.cache = new Caches(this);
        this.bus = null;
        this.legacyBus = null;
        if (props == null) {
            props = new Properties();
        }
        this.legacy = (disabled = Boolean.valueOf(prop = OpenBusProperty.LEGACY_DISABLE.getProperty(props))) == false;
        this.delegate = OpenBusProperty.LEGACY_DELEGATE.getProperty(props);
        try {
            this.context.ignoreCurrentThread();
            this.buildCorbaLoc(host, port);
        }
        finally {
            this.context.unignoreCurrentThread();
        }
        try {
            this.crypto = Cryptography.getInstance();
            KeyPair keyPair = this.crypto.generateRSAKeyPair();
            this.publicKey = (RSAPublicKey)keyPair.getPublic();
            this.privateKey = (RSAPrivateKey)keyPair.getPrivate();
        }
        catch (CryptographyException e) {
            throw new OpenBusInternalException("Erro inexperado na gera\u00e7\u00e3o do par de chaves.", e);
        }
        this.internalLogin = new InternalLogin(this);
    }

    @Override
    public ORB orb() {
        return this.orb;
    }

    @Override
    public String busid() {
        return this.getBus().getId();
    }

    RSAPublicKey getBusPublicKey() {
        return this.getBus().getPublicKey();
    }

    RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    private void checkLoggedIn() throws AlreadyLoggedIn {
        LoginInfo login = this.internalLogin.login();
        if (login != null) {
            throw new AlreadyLoggedIn();
        }
    }

    private void buildCorbaLoc(String host, int port) {
        String str = String.format("corbaloc::1.0@%s:%d/%s", host, port, "OpenBus_2_0");
        Object obj = this.orb.string_to_object(str);
        this.bus = new BusInfo(obj);
        if (this.legacy) {
            String legacyStr = String.format("corbaloc::1.0@%s:%d/%s", host, port, "openbus_v1_05");
            Object legacyObj = this.orb.string_to_object(legacyStr);
            this.legacyBus = new LegacyInfo(legacyObj);
        }
    }

    private void initBusReferencesBeforeLogin() {
        this.bus.basicBusInitialization();
        if (this.legacy) {
            this.legacy = this.legacyBus.activateLegacySuport();
        }
    }

    @Override
    public void loginByPassword(String entity, byte[] password) throws AccessDenied, AlreadyLoggedIn, ServiceFailure {
        LoginInfo newLogin;
        this.checkLoggedIn();
        try {
            this.context.ignoreCurrentThread();
            this.initBusReferencesBeforeLogin();
            byte[] encryptedLoginAuthenticationInfo = this.generateEncryptedLoginAuthenticationInfo(password);
            IntHolder validityHolder = new IntHolder();
            newLogin = this.access().loginByPassword(entity, this.publicKey.getEncoded(), encryptedLoginAuthenticationInfo, validityHolder);
            this.localLogin(newLogin, validityHolder.value);
        }
        catch (WrongEncoding e) {
            throw new ServiceFailure("Falhou a codifica\u00e7\u00e3o com a chave p\u00fablica do barramento");
        }
        catch (InvalidPublicKey e) {
            throw new OpenBusInternalException("Falha no protocolo OpenBus: A chave de acesso gerada n\u00e3o foi aceita. Mensagem=" + e.message);
        }
        finally {
            this.context.unignoreCurrentThread();
        }
        logger.info(String.format("Login por senha efetuado com sucesso: busid (%s) login (%s) entidade (%s)", this.busid(), newLogin.id, newLogin.entity));
    }

    private byte[] generateEncryptedLoginAuthenticationInfo(byte[] data) {
        try {
            byte[] publicKeyHash = this.crypto.generateHash(this.publicKey.getEncoded());
            LoginAuthenticationInfo authenticationInfo = new LoginAuthenticationInfo(publicKeyHash, data);
            Any authenticationInfoAny = this.orb.create_any();
            LoginAuthenticationInfoHelper.insert(authenticationInfoAny, authenticationInfo);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            byte[] encodedLoginAuthenticationInfo = mediator.getCodec().encode_value(authenticationInfoAny);
            return this.crypto.encrypt(encodedLoginAuthenticationInfo, this.getBus().getPublicKey());
        }
        catch (InvalidTypeForEncoding e) {
            throw new OpenBusInternalException("Falha inesperada ao codificar as informa\u00e7\u00f5es de autentica\u00e7\u00e3o", e);
        }
        catch (CryptographyException e) {
            throw new OpenBusInternalException("Erro de criptografia com uso de chave p\u00fablica.", e);
        }
    }

    @Override
    public void loginByCertificate(String entity, PrivateKey privateKey) throws AlreadyLoggedIn, MissingCertificate, AccessDenied, ServiceFailure {
        LoginInfo newLogin;
        this.checkLoggedIn();
        this.context.ignoreCurrentThread();
        this.initBusReferencesBeforeLogin();
        LoginProcessOperations loginProcess = null;
        OpenBusPrivateKey privKey = (OpenBusPrivateKey)privateKey;
        try {
            EncryptedBlockHolder challengeHolder = new EncryptedBlockHolder();
            loginProcess = this.access().startLoginByCertificate(entity, challengeHolder);
            byte[] decryptedChallenge = this.crypto.decrypt(challengeHolder.value, privKey.getRSAPrivateKey());
            byte[] encryptedLoginAuthenticationInfo = this.generateEncryptedLoginAuthenticationInfo(decryptedChallenge);
            IntHolder validityHolder = new IntHolder();
            newLogin = loginProcess.login(this.publicKey.getEncoded(), encryptedLoginAuthenticationInfo, validityHolder);
            this.localLogin(newLogin, validityHolder.value);
        }
        catch (CryptographyException e) {
            loginProcess.cancel();
            throw new AccessDenied("Erro ao descriptografar desafio.");
        }
        catch (WrongEncoding e) {
            throw new OpenBusInternalException("Falhou a codifica\u00e7\u00e3o com a chave p\u00fablica do barramento", (Throwable)((java.lang.Object)e));
        }
        catch (InvalidPublicKey e) {
            throw new OpenBusInternalException("Falha no protocolo OpenBus: A chave de acesso gerada n\u00e3o foi aceita. Mensagem=" + e.message);
        }
        finally {
            this.context.unignoreCurrentThread();
        }
        logger.info(String.format("Login por certificado efetuada com sucesso: busid (%s) login (%s) entidade (%s)", this.busid(), newLogin.id, newLogin.entity));
    }

    @Override
    public LoginProcess startSharedAuth(OctetSeqHolder secret) throws ServiceFailure {
        EncryptedBlockHolder challenge = new EncryptedBlockHolder();
        LoginProcessOperations process = null;
        Connection previousConnection = this.context.getCurrentConnection();
        try {
            this.context.setCurrentConnection(this);
            process = this.access().startLoginBySharedAuth(challenge);
            secret.value = this.crypto.decrypt(challenge.value, this.privateKey);
        }
        catch (CryptographyException e) {
            process.cancel();
            throw new OpenBusInternalException("Erro ao descriptografar segredo com chave privada.", e);
        }
        finally {
            this.context.setCurrentConnection(previousConnection);
        }
        return process;
    }

    @Override
    public void loginBySharedAuth(LoginProcess process, byte[] secret) throws AlreadyLoggedIn, ServiceFailure, AccessDenied, InvalidLoginProcess {
        LoginInfo newLogin;
        this.checkLoggedIn();
        this.context.ignoreCurrentThread();
        this.initBusReferencesBeforeLogin();
        byte[] encryptedLoginAuthenticationInfo = this.generateEncryptedLoginAuthenticationInfo(secret);
        IntHolder validity = new IntHolder();
        try {
            newLogin = process.login(this.publicKey.getEncoded(), encryptedLoginAuthenticationInfo, validity);
            this.localLogin(newLogin, validity.value);
        }
        catch (WrongEncoding e) {
            throw new AccessDenied("Erro durante tentativa de login.");
        }
        catch (OBJECT_NOT_EXIST e) {
            throw new InvalidLoginProcess("Objeto de processo de login \u00e9 inv\u00e1lido");
        }
        catch (InvalidPublicKey e) {
            throw new OpenBusInternalException("Falha no protocolo OpenBus: A chave de acesso gerada n\u00e3o foi aceita. Mensagem=" + e.message);
        }
        finally {
            this.context.unignoreCurrentThread();
        }
        logger.info(String.format("Login por compatilhamento de autentica\u00e7\u00e3o efetuado com sucesso: busid (%s) login (%s) entidade (%s)", this.busid(), newLogin.id, newLogin.entity));
    }

    private void fireRenewerThread(int defaultLease) {
        if (this.renewer != null) {
            this.renewer.stop();
        }
        this.renewer = new LeaseRenewer(this, defaultLease);
        this.renewer.start();
    }

    private void stopRenewerThread() {
        if (this.renewer != null) {
            this.renewer.stop();
        }
        this.renewer = null;
    }

    @Override
    public LoginInfo login() {
        return this.internalLogin.login();
    }

    LoginInfo getLogin() {
        return this.internalLogin.getLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localLogin(LoginInfo newLogin, int validity) throws AlreadyLoggedIn {
        this.writeLock().lock();
        try {
            this.checkLoggedIn();
            this.internalLogin.setLoggedIn(newLogin);
        }
        finally {
            this.writeLock().unlock();
        }
        this.fireRenewerThread(validity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws ServiceFailure {
        LoginInfo login = this.internalLogin.login();
        if (login == null) {
            if (this.internalLogin.invalid() != null) {
                this.localLogout(false);
            }
            return false;
        }
        Connection previousConnection = this.context.getCurrentConnection();
        CallerChain previousChain = this.context.getJoinedChain();
        try {
            this.context.exitChain();
            this.context.setCurrentConnection(this);
            this.access().logout();
        }
        catch (SystemException e) {
            logger.log(Level.WARNING, String.format("Erro durante chamada remota de logout: busid (%s) login (%s) entidade (%s)", this.busid(), login.id, login.entity), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.context.setCurrentConnection(previousConnection);
            this.context.joinChain(previousChain);
            this.localLogout(false);
        }
        return true;
    }

    void localLogout(boolean invalidated) {
        this.cache.clear();
        this.bus.clearBusInfos();
        this.stopRenewerThread();
        if (invalidated) {
            this.internalLogin.setInvalid();
        } else {
            LoginInfo old = this.internalLogin.setLoggedOut();
            if (old != null) {
                logger.info(String.format("Logout efetuado: id (%s) entidade (%s)", old.id, old.entity));
            }
        }
    }

    AccessControl access() {
        return this.getBus().getAccessControl();
    }

    LoginRegistry logins() {
        return this.getBus().getLoginRegistry();
    }

    OfferRegistry offers() {
        return this.getBus().getOfferRegistry();
    }

    @Override
    public void onInvalidLoginCallback(InvalidLoginCallback callback) {
        this.invalidLoginCallback = callback;
    }

    @Override
    public InvalidLoginCallback onInvalidLoginCallback() {
        return this.invalidLoginCallback;
    }

    void setLegacyInfo(LegacyInfo legacy) {
        this.legacyBus = legacy;
    }

    boolean legacy() {
        if (!this.legacy) {
            return false;
        }
        return this.legacyBus != null;
    }

    IAccessControlService legacyAccess() {
        return this.legacyBus.getAccessControl();
    }

    BusInfo getBus() {
        return this.bus;
    }

    ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock;
    }

    ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock;
    }

    String connId() {
        return this.connId;
    }

    void setLoginInvalid() {
        this.internalLogin.setInvalid();
    }

    boolean isLegacyDelegateSetToOriginator() {
        return this.delegate.equals("originator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextAvailableSessionId() {
        Map<Integer, Session.ServerSideSession> map = this.cache.srvSessions;
        synchronized (map) {
            for (int i = 1; i <= this.cache.CACHE_SIZE + 1; ++i) {
                if (this.cache.srvSessions.containsKey(i)) continue;
                return i;
            }
        }
        return this.cache.CACHE_SIZE + 1;
    }

    public boolean equals(java.lang.Object obj) {
        ConnectionImpl other = null;
        if (obj instanceof ConnectionImpl) {
            other = (ConnectionImpl)obj;
            return this.connId.equals(other.connId);
        }
        return false;
    }

    public int hashCode() {
        return this.connId.hashCode();
    }

    public String toString() {
        return this.connId;
    }

    class Caches {
        final int CACHE_SIZE = 30;
        Map<EffectiveProfile, String> entities = Collections.synchronizedMap(new LRUCache(30));
        Map<String, Session.ClientSideSession> cltSessions = Collections.synchronizedMap(new LRUCache(30));
        Map<ChainCacheKey, SignedCallChain> chains = Collections.synchronizedMap(new LRUCache(30));
        Map<Integer, Session.ServerSideSession> srvSessions = Collections.synchronizedMap(new LRUCache(30));
        LoginCache logins;
        IsValidCache valids;

        public Caches(ConnectionImpl conn) {
            this.logins = new LoginCache(conn, 30);
            this.valids = new IsValidCache(conn, 30);
        }

        protected void clear() {
            this.entities.clear();
            this.cltSessions.clear();
            this.chains.clear();
            this.srvSessions.clear();
            this.logins.clear();
            this.valids.clear();
        }
    }
}

