/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Clock;
import demo.ClockHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AssistantParams;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class DedicatedClockClient {
    private static String host;
    private static int port;
    private static String entity;
    private static String password;
    private static int interval;
    private static int retries;

    public static void main(String[] args) throws AlreadyLoggedIn, InvalidName, ServiceFailure {
        ServiceOfferDesc[] services;
        if (args.length < 3) {
            String params = "[interval] [timeout]";
            String desc = "\n  - [interval] = Tempo de espera entre tentativas de acesso ao barramento em virtude de falhas. Valor padr\u00e3o \u00e9 '1'\n  - [retries] = N\u00famero m\u00e1ximo de tentativas de acesso ao barramento em virtude de falhas. Valor padr\u00e3o \u00e9 '10'";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> [password] %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - password = senha (opcional) %s", params, desc));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        password = entity = args[2];
        if (args.length > 3) {
            password = args[3];
        }
        if (args.length > 4) {
            try {
                interval = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor de [interval] deve ser um n\u00famero");
                System.exit(1);
                return;
            }
        }
        if (args.length > 5) {
            try {
                retries = Integer.parseInt(args[5]);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor de [retries] deve ser um n\u00famero");
                System.exit(1);
                return;
            }
        }
        AssistantParams params = new AssistantParams();
        params.interval = interval;
        Assistant assist = Assistant.createWithPassword((String)host, (int)port, (String)entity, (byte[])password.getBytes(), (AssistantParams)params);
        Long timestamp = null;
        ServiceProperty[] properties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Dedicated Clock")};
        try {
            services = assist.findServices(properties, retries);
        }
        catch (ServiceFailure e) {
            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            System.exit(1);
            return;
        }
        catch (TRANSIENT e) {
            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            System.exit(1);
            return;
        }
        catch (COMM_FAILURE e) {
            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            System.exit(1);
            return;
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
            }
            System.exit(1);
            return;
        }
        catch (Throwable e) {
            System.err.println("Erro inesperado durante busca de servi\u00e7os.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        block22: for (ServiceOfferDesc offerDesc : services) {
            try {
                Object helloObj = offerDesc.service_ref.getFacet(ClockHelper.id());
                if (helloObj == null) {
                    System.out.println("o servi\u00e7o encontrado n\u00e3o prov\u00ea a faceta ofertada");
                    continue;
                }
                Clock clock = ClockHelper.narrow(helloObj);
                timestamp = clock.getTimeInTicks();
            }
            catch (TRANSIENT e) {
                System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
            }
            catch (COMM_FAILURE e) {
                System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
            }
            catch (NO_PERMISSION e) {
                switch (e.minor) {
                    case 1112888319: {
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                        continue block22;
                    }
                    case 1112888068: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                        continue block22;
                    }
                    case 1112888067: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                        continue block22;
                    }
                    case 1112888318: {
                        System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                    }
                }
            }
        }
        if (timestamp != null) {
            Date date = new Date(timestamp);
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
            System.out.println(formatter.format(date));
        } else {
            System.out.println("Service is unavailable.");
        }
        assist.shutdown();
    }

    static {
        interval = 1;
        retries = 10;
    }
}

