/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Greetings;
import demo.GreetingsHelper;
import demo.GreetingsImpl;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.exception.SCSException;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class GreetingsServer {
    private static String host;
    private static int port;
    private static String entity;
    private static OpenBusPrivateKey privateKey;

    public static void main(String[] args) throws InvalidName, AdapterInactive, SCSException, AlreadyLoggedIn, ServiceFailure {
        if (args.length < 4) {
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> <privatekeypath> %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - privatekeypath = \u00e9 o caminho da chave privada de autentica\u00e7\u00e3o da entidade %s", "", ""));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        entity = args[2];
        String privateKeyFile = args[3];
        try {
            privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
        }
        catch (Exception e) {
            System.out.println("<privatekeypath> deve apontar para uma chave v\u00e1lida.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        final Assistant assist = Assistant.createWithPrivateKey((String)host, (int)port, (String)entity, (PrivateKey)privateKey);
        final ORB orb = assist.orb();
        Thread run = new Thread(){

            @Override
            public void run() {
                orb.run();
            }
        };
        run.start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                assist.shutdown();
                orb.shutdown(true);
                orb.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        for (GreetingsImpl.Language language : GreetingsImpl.Language.values()) {
            ComponentId id = new ComponentId(language.name() + Greetings.class.getSimpleName(), 1, 0, 0, "java");
            ComponentContext component = new ComponentContext(orb, poa, id);
            for (GreetingsImpl.Period period : GreetingsImpl.Period.values()) {
                component.addFacet("Good" + period.name(), GreetingsHelper.id(), (Servant)new GreetingsImpl(context, language, period));
            }
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Greetings"), new ServiceProperty("greetings.language", language.name())};
            assist.registerService(component.getIComponent(), serviceProperties);
        }
    }
}

