/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.GreetingsPOA;
import tecgraf.openbus.OpenBusContext;

public class GreetingsImpl
extends GreetingsPOA {
    private OpenBusContext context;
    private Period period;
    private Language language;

    public GreetingsImpl(OpenBusContext context, Language language, Period period) {
        this.context = context;
        this.language = language;
        this.period = period;
    }

    @Override
    public String sayGreetings() {
        String caller = this.context.getCallerChain().caller().entity;
        switch (this.language) {
            case English: {
                return this.englishGreetings(caller);
            }
            case Spanish: {
                return this.spanishGreetings(caller);
            }
            case Portuguese: {
                return this.portugueseGreetings(caller);
            }
        }
        return "BUG: lingua n\u00e3o especificada";
    }

    private String englishGreetings(String caller) {
        switch (this.period) {
            case Morning: {
                return String.format("Good morning %s", caller);
            }
            case Afternoon: {
                return String.format("Good afternoon %s", caller);
            }
            case Night: {
                return String.format("Good night %s", caller);
            }
        }
        return "BUG: periodo n\u00e3o especificado";
    }

    private String spanishGreetings(String caller) {
        switch (this.period) {
            case Morning: {
                return String.format("Buenos d\u00edas %s", caller);
            }
            case Afternoon: {
                return String.format("Buenas tardes %s", caller);
            }
            case Night: {
                return String.format("Buenas noches %s", caller);
            }
        }
        return "BUG: periodo n\u00e3o especificado";
    }

    private String portugueseGreetings(String caller) {
        switch (this.period) {
            case Morning: {
                return String.format("Bom dia %s", caller);
            }
            case Afternoon: {
                return String.format("Boa tarde %s", caller);
            }
            case Night: {
                return String.format("Boa noite %s", caller);
            }
        }
        return "BUG: periodo n\u00e3o especificado";
    }

    public static enum Period {
        Morning,
        Afternoon,
        Night;

    }

    public static enum Language {
        English,
        Spanish,
        Portuguese;

    }
}

