/*
 * Decompiled with CFR 0.152.
 */
package scs.core.servant;

import java.lang.reflect.InvocationTargetException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import scs.core.ComponentId;
import scs.core.FacetDescription;
import scs.core.IComponentHelper;
import scs.core.IMetaInterfaceHelper;
import scs.core.IReceptaclesHelper;
import scs.core.ReceptacleDescription;
import scs.core.servant.ComponentContext;
import scs.core.servant.ComponentContextImpl;
import scs.core.servant.ExtendedFacetDescription;
import scs.core.servant.IComponentServant;
import scs.core.servant.IMetaInterfaceServant;
import scs.core.servant.IReceptaclesServant;
import scs.core.servant.Receptacle;

public class ComponentBuilder {
    private POA poa;
    private ORB orb;

    public ComponentBuilder(POA pOA, ORB oRB) {
        this.poa = pOA;
        this.orb = oRB;
    }

    private void addFacetDescsToComponent(ComponentContext componentContext, ExtendedFacetDescription extendedFacetDescription, Servant servant) throws ServantNotActive, WrongPolicy {
        FacetDescription facetDescription = new FacetDescription();
        facetDescription.name = extendedFacetDescription.name;
        facetDescription.interface_name = extendedFacetDescription.interface_name;
        facetDescription.facet_ref = this.poa.servant_to_reference(servant);
        componentContext.getFacetDescs().put(facetDescription.name, facetDescription);
        componentContext.getExtendedFacetDescs().put(extendedFacetDescription.name, extendedFacetDescription);
        componentContext.getFacets().put(extendedFacetDescription.name, servant);
    }

    private void addBasicFacets(ComponentContext componentContext) throws ServantNotActive, WrongPolicy, BadKind {
        Object object;
        Object object2;
        Object object3;
        String string = IComponentHelper.type().name();
        if (!componentContext.getFacetDescs().containsKey(string)) {
            object3 = new IComponentServant(componentContext);
            object2 = new ExtendedFacetDescription(string, IComponentHelper.id(), IComponentServant.class.getSimpleName());
            this.addFacetDescsToComponent(componentContext, (ExtendedFacetDescription)object2, (Servant)object3);
        }
        object3 = IReceptaclesHelper.type().name();
        if (!componentContext.getFacetDescs().containsKey(object3)) {
            object2 = new IReceptaclesServant(componentContext);
            object = new ExtendedFacetDescription((String)object3, IReceptaclesHelper.id(), IReceptaclesServant.class.getSimpleName());
            this.addFacetDescsToComponent(componentContext, (ExtendedFacetDescription)object, (Servant)object2);
        }
        object2 = IMetaInterfaceHelper.type().name();
        if (!componentContext.getFacetDescs().containsKey(object2)) {
            object = new IMetaInterfaceServant(componentContext);
            ExtendedFacetDescription extendedFacetDescription = new ExtendedFacetDescription((String)object2, IMetaInterfaceHelper.id(), IMetaInterfaceServant.class.getSimpleName());
            this.addFacetDescsToComponent(componentContext, extendedFacetDescription, (Servant)object);
        }
    }

    public ComponentContext newComponent(ExtendedFacetDescription[] extendedFacetDescriptionArray, ReceptacleDescription[] receptacleDescriptionArray, ComponentId componentId) throws ServantNotActive, WrongPolicy, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, BadKind {
        Object object;
        Object object2;
        int n;
        if (componentId == null) {
            throw new IllegalArgumentException("ComponentId null!");
        }
        ComponentContextImpl componentContextImpl = new ComponentContextImpl(this, componentId);
        if (receptacleDescriptionArray != null) {
            for (n = 0; n < receptacleDescriptionArray.length; ++n) {
                object2 = receptacleDescriptionArray[n];
                object = new Receptacle((ReceptacleDescription)object2);
                componentContextImpl.getReceptacleDescs().put(object2.name, (ReceptacleDescription)object2);
                componentContextImpl.getReceptacles().put(object2.name, (Receptacle)object);
            }
        }
        if (extendedFacetDescriptionArray != null) {
            for (n = 0; n < extendedFacetDescriptionArray.length; ++n) {
                object2 = extendedFacetDescriptionArray[n];
                object = Class.forName(object2.class_name);
                try {
                    ((Class)object).getMethod("_get_component", null);
                }
                catch (Exception exception) {
                    System.err.println("_get_component nao foi definida para a classe " + object2.class_name + "!");
                }
                Object t = ((Class)object).getConstructor(ComponentContext.class).newInstance(componentContextImpl);
                if (!(t instanceof Servant)) continue;
                this.addFacetDescsToComponent(componentContextImpl, (ExtendedFacetDescription)object2, (Servant)t);
            }
        }
        this.addBasicFacets(componentContextImpl);
        return componentContextImpl;
    }

    public static String componentIdToString(ComponentId componentId) {
        return componentId.name + String.valueOf(componentId.major_version) + String.valueOf(componentId.minor_version) + String.valueOf(componentId.patch_version);
    }

    public POA getPOA() {
        return this.poa;
    }

    public ORB getORB() {
        return this.orb;
    }
}

