/*
 * Decompiled with CFR 0.152.
 */
package scs.core.servant;

import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.Object;
import scs.core.AlreadyConnected;
import scs.core.ConnectionDescription;
import scs.core.ReceptacleDescription;

public class Receptacle {
    ReceptacleDescription desc;
    ArrayList<ConnectionDescription> connections;

    public Receptacle(ReceptacleDescription receptacleDescription) {
        this.desc = receptacleDescription;
        this.connections = new ArrayList();
    }

    public ReceptacleDescription getReceptacleDescription() {
        this.desc.connections = this.connections.toArray(new ConnectionDescription[this.connections.size()]);
        return this.desc;
    }

    public String getName() {
        return this.desc.name;
    }

    public String getInterfaceName() {
        return this.desc.interface_name;
    }

    public boolean isMultiplex() {
        return this.desc.is_multiplex;
    }

    public ArrayList<ConnectionDescription> getConnections() {
        return this.connections;
    }

    public ConnectionDescription getConnection(int n) {
        for (ConnectionDescription connectionDescription : this.connections) {
            if (connectionDescription.id != n) continue;
            return connectionDescription;
        }
        return null;
    }

    public int addConnection(int n, Object object) throws AlreadyConnected {
        for (ConnectionDescription connectionDescription : this.connections) {
            if (!connectionDescription.objref.equals(object)) continue;
            throw new AlreadyConnected();
        }
        ConnectionDescription connectionDescription = new ConnectionDescription();
        connectionDescription.id = n;
        connectionDescription.objref = object;
        this.connections.add(connectionDescription);
        return connectionDescription.id;
    }

    public void removeConnection(int n) {
        Iterator<ConnectionDescription> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            ConnectionDescription connectionDescription = iterator.next();
            if (connectionDescription.id != n) continue;
            iterator.remove();
        }
    }
}

