/*
 * Decompiled with CFR 0.152.
 */
package scs.core;

import java.util.Collection;
import java.util.Iterator;
import org.omg.CORBA.Object;
import scs.core.ComponentContext;
import scs.core.Facet;
import scs.core.FacetDescription;
import scs.core.IMetaInterfacePOA;
import scs.core.InvalidName;
import scs.core.Receptacle;
import scs.core.ReceptacleDescription;

public class IMetaInterfaceServant
extends IMetaInterfacePOA {
    protected ComponentContext myComponent;

    public IMetaInterfaceServant(ComponentContext myComponent) {
        this.myComponent = myComponent;
    }

    @Override
    public FacetDescription[] getFacets() {
        Collection<Facet> facets = this.myComponent.getFacets();
        FacetDescription[] descriptions = new FacetDescription[facets.size()];
        Iterator<Facet> facetsIterator = facets.iterator();
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = facetsIterator.next().getDescription();
        }
        return descriptions;
    }

    @Override
    public FacetDescription[] getFacetsByName(String[] names) throws InvalidName {
        FacetDescription[] facets = new FacetDescription[names.length];
        for (int i = 0; i < names.length; ++i) {
            Facet facet = this.myComponent.getFacetByName(names[i]);
            if (facet == null) {
                throw new InvalidName(names[i]);
            }
            facets[i] = facet.getDescription();
        }
        return facets;
    }

    @Override
    public ReceptacleDescription[] getReceptacles() {
        Collection<Receptacle> receptacles = this.myComponent.getReceptacles();
        ReceptacleDescription[] descriptions = new ReceptacleDescription[receptacles.size()];
        Iterator<Receptacle> receptaclesIterator = receptacles.iterator();
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = receptaclesIterator.next().getDescription();
        }
        return descriptions;
    }

    @Override
    public ReceptacleDescription[] getReceptaclesByName(String[] names) throws InvalidName {
        ReceptacleDescription[] receptacles = new ReceptacleDescription[names.length];
        for (int i = 0; i < names.length; ++i) {
            Receptacle receptacle = this.myComponent.getReceptacleByName(names[i]);
            if (receptacle == null) {
                throw new InvalidName(names[i]);
            }
            receptacles[i] = receptacle.getDescription();
        }
        return receptacles;
    }

    public Object _get_component() {
        return this.myComponent.getIComponent();
    }
}

