/*
 * Decompiled with CFR 0.152.
 */
package scs.core;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.Object;
import scs.core.AlreadyConnected;
import scs.core.ComponentContext;
import scs.core.ConnectionDescription;
import scs.core.ExceededConnectionLimit;
import scs.core.InvalidConnection;
import scs.core.ReceptacleDescription;

public class Receptacle {
    private final String name;
    private final String interface_name;
    private final boolean is_multiplex;
    private ComponentContext myComponent;
    private List<ConnectionDescription> connections;

    Receptacle(ComponentContext context, String name, String interface_name, boolean is_multiplex) {
        if (context == null) {
            throw new IllegalArgumentException("The component's context can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("The name can't be null");
        }
        if (interface_name == null) {
            throw new IllegalArgumentException("The interface's name can't be null");
        }
        this.myComponent = context;
        this.name = name;
        this.interface_name = interface_name;
        this.is_multiplex = is_multiplex;
        this.connections = new LinkedList<ConnectionDescription>();
    }

    public String getName() {
        return this.name;
    }

    public String getInterfaceName() {
        return this.interface_name;
    }

    public boolean isMultiplex() {
        return this.is_multiplex;
    }

    public synchronized ReceptacleDescription getDescription() {
        return new ReceptacleDescription(this.name, this.interface_name, this.is_multiplex, this.connections.toArray(new ConnectionDescription[0]));
    }

    public synchronized List<ConnectionDescription> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public synchronized int getConnectionsSize() {
        return this.connections.size();
    }

    public synchronized void clearConnections() {
        this.connections.clear();
    }

    public synchronized int addConnection(Object obj) throws AlreadyConnected, ExceededConnectionLimit, InvalidConnection {
        if (obj == null) {
            throw new IllegalArgumentException("The connection can't be null");
        }
        if (!this.is_multiplex && this.getConnectionsSize() > 0) {
            throw new AlreadyConnected();
        }
        int numConnections = 0;
        for (Receptacle receptacle : this.myComponent.getReceptacles()) {
            numConnections += receptacle.getConnectionsSize();
        }
        if (numConnections >= this.myComponent.CONNECTION_LIMIT) {
            throw new ExceededConnectionLimit();
        }
        if (!obj._is_a(this.interface_name)) {
            throw new InvalidConnection();
        }
        int newId = this.myComponent.generateConnectionId();
        this.connections.add(new ConnectionDescription(newId, obj));
        return newId;
    }

    public synchronized boolean removeConnection(int id) {
        if (id <= 0) {
            throw new IllegalArgumentException("The connection's id can't be less than zero");
        }
        int connectionIndex = -1;
        for (int i = 0; i < this.connections.size(); ++i) {
            ConnectionDescription connection = this.connections.get(i);
            if (connection.id != id) continue;
            connectionIndex = i;
            break;
        }
        if (connectionIndex == -1) {
            return false;
        }
        this.connections.remove(connectionIndex);
        return true;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Receptacle receptacle = (Receptacle)obj;
        return this.name.equals(receptacle.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

