/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UUIDBox
extends Box {
    private static String[] elementNames = new String[]{"UUID", "Data"};
    private byte[] uuid;
    private byte[] udata;

    public static String[] getElementNames() {
        return elementNames;
    }

    public UUIDBox(byte[] data) {
        super(8 + data.length, 1970628964, data);
    }

    public UUIDBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("UUID".equals(name)) {
                this.uuid = Box.getByteArrayElementValue(child);
            }
            if ("Data".equals(name)) {
                this.udata = Box.getByteArrayElementValue(child);
            }
            ++i;
        }
    }

    protected void parse(byte[] data) {
        this.uuid = new byte[16];
        System.arraycopy(data, 0, this.uuid, 0, 16);
        this.udata = new byte[data.length - 16];
        System.arraycopy(data, 16, this.udata, 0, this.udata.length);
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public byte[] getData() {
        return this.udata;
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[16 + this.udata.length];
        System.arraycopy(this.uuid, 0, this.data, 0, 16);
        System.arraycopy(this.udata, 0, this.data, 16, this.udata.length);
    }
}

