/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.TagTreeEncoder;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class PktEncoder {
    public static final char OPT_PREFIX = 'P';
    private static final String[][] pinfo;
    private static final int INIT_LBLOCK = 3;
    private CodedCBlkDataSrcEnc infoSrc;
    J2KImageWriteParamJava wp;
    private TagTreeEncoder[][][][][] ttIncl;
    private TagTreeEncoder[][][][][] ttMaxBP;
    private int[][][][][] lblock;
    private int[][][][][] prevtIdxs;
    private int[][][][][] bak_lblock;
    private int[][][][][] bak_prevtIdxs;
    private byte[] lbbuf;
    private int lblen;
    private boolean saved;
    private boolean roiInPkt = false;
    private int roiLen = 0;
    private PrecInfo[][][][] ppinfo;
    private boolean packetWritable;

    public PktEncoder(CodedCBlkDataSrcEnc infoSrc, J2KImageWriteParamJava wp, Point[][][] numPrec) {
        this.infoSrc = infoSrc;
        this.wp = wp;
        int nc = infoSrc.getNumComps();
        int nt = infoSrc.getNumTiles();
        this.ttIncl = new TagTreeEncoder[nt][nc][][][];
        this.ttMaxBP = new TagTreeEncoder[nt][nc][][][];
        this.lblock = new int[nt][nc][][][];
        this.prevtIdxs = new int[nt][nc][][][];
        this.ppinfo = new PrecInfo[nt][nc][][];
        Object tmpCoord = null;
        Object cblks = null;
        infoSrc.setTile(0, 0);
        int t = 0;
        while (t < nt) {
            int c = 0;
            while (c < nc) {
                SubbandAn root = infoSrc.getAnSubbandTree(t, c);
                int mrl = root.resLvl;
                this.lblock[t][c] = new int[mrl + 1][][];
                this.ttIncl[t][c] = new TagTreeEncoder[mrl + 1][][];
                this.ttMaxBP[t][c] = new TagTreeEncoder[mrl + 1][][];
                this.prevtIdxs[t][c] = new int[mrl + 1][][];
                this.ppinfo[t][c] = new PrecInfo[mrl + 1][];
                int r = 0;
                while (r <= mrl) {
                    int mins = r == 0 ? 0 : 1;
                    int maxs = r == 0 ? 1 : 4;
                    int maxPrec = numPrec[t][c][r].x * numPrec[t][c][r].y;
                    this.ttIncl[t][c][r] = new TagTreeEncoder[maxPrec][maxs];
                    this.ttMaxBP[t][c][r] = new TagTreeEncoder[maxPrec][maxs];
                    this.prevtIdxs[t][c][r] = new int[maxs][];
                    this.lblock[t][c][r] = new int[maxs][];
                    this.ppinfo[t][c][r] = new PrecInfo[maxPrec];
                    this.fillPrecInfo(t, c, r);
                    int s = mins;
                    while (s < maxs) {
                        SubbandAn sb = (SubbandAn)root.getSubbandByIdx(r, s);
                        int numcb = sb.numCb.x * sb.numCb.y;
                        this.lblock[t][c][r][s] = new int[numcb];
                        ArrayUtil.intArraySet(this.lblock[t][c][r][s], 3);
                        this.prevtIdxs[t][c][r][s] = new int[numcb];
                        ArrayUtil.intArraySet(this.prevtIdxs[t][c][r][s], -1);
                        ++s;
                    }
                    ++r;
                }
                ++c;
            }
            if (t != nt - 1) {
                infoSrc.nextTile();
            }
            ++t;
        }
    }

    private void fillPrecInfo(int t, int c, int r) {
        if (this.ppinfo[t][c][r].length == 0) {
            return;
        }
        Point tileI = this.infoSrc.getTile(null);
        Point nTiles = this.infoSrc.getNumTiles(null);
        int x0siz = this.infoSrc.getImgULX();
        int y0siz = this.infoSrc.getImgULY();
        int xsiz = x0siz + this.infoSrc.getImgWidth();
        int ysiz = y0siz + this.infoSrc.getImgHeight();
        int xt0siz = this.infoSrc.getTilePartULX();
        int yt0siz = this.infoSrc.getTilePartULY();
        int xtsiz = this.infoSrc.getNomTileWidth();
        int ytsiz = this.infoSrc.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int xrsiz = this.infoSrc.getCompSubsX(c);
        int yrsiz = this.infoSrc.getCompSubsY(c);
        int tcx0 = (int)Math.ceil((double)tx0 / (double)xrsiz);
        int tcy0 = (int)Math.ceil((double)ty0 / (double)yrsiz);
        int tcx1 = (int)Math.ceil((double)tx1 / (double)xrsiz);
        int tcy1 = (int)Math.ceil((double)ty1 / (double)yrsiz);
        int ndl = this.infoSrc.getAnSubbandTree((int)t, (int)c).resLvl - r;
        int trx0 = (int)Math.ceil((double)tcx0 / (double)(1 << ndl));
        int try0 = (int)Math.ceil((double)tcy0 / (double)(1 << ndl));
        int trx1 = (int)Math.ceil((double)tcx1 / (double)(1 << ndl));
        int try1 = (int)Math.ceil((double)tcy1 / (double)(1 << ndl));
        int cb0x = this.infoSrc.getCbULX();
        int cb0y = this.infoSrc.getCbULY();
        double twoppx = this.wp.getPrecinctPartition().getPPX(t, c, r);
        double twoppy = this.wp.getPrecinctPartition().getPPY(t, c, r);
        int twoppx2 = (int)(twoppx / 2.0);
        int twoppy2 = (int)(twoppy / 2.0);
        int maxPrec = this.ppinfo[t][c][r].length;
        int nPrec = 0;
        int istart = (int)Math.floor((double)(try0 - cb0y) / twoppy);
        int iend = (int)Math.floor((double)(try1 - 1 - cb0y) / twoppy);
        int jstart = (int)Math.floor((double)(trx0 - cb0x) / twoppx);
        int jend = (int)Math.floor((double)(trx1 - 1 - cb0x) / twoppx);
        SubbandAn root = this.infoSrc.getAnSubbandTree(t, c);
        SubbandAn sb = null;
        int prg_w = (int)twoppx << ndl;
        int prg_h = (int)twoppy << ndl;
        int i = istart;
        while (i <= iend) {
            int j = jstart;
            while (j <= jend) {
                CBlkCoordInfo cb;
                int l;
                int k;
                int lend;
                int lstart;
                int l0;
                int kend;
                int kstart;
                int k0;
                int ch;
                int cw;
                int s1y;
                int s0y;
                int s1x;
                int s0x;
                int p1y;
                int p0y;
                int p1x;
                int p0x;
                int acb0y;
                int acb0x;
                int prg_ulx = j == jstart && (trx0 - cb0x) % (xrsiz * (int)twoppx) != 0 ? tx0 : cb0x + j * xrsiz * ((int)twoppx << ndl);
                int prg_uly = i == istart && (try0 - cb0y) % (yrsiz * (int)twoppy) != 0 ? ty0 : cb0y + i * yrsiz * ((int)twoppy << ndl);
                this.ppinfo[t][c][r][nPrec] = new PrecInfo(r, (int)((double)cb0x + (double)j * twoppx), (int)((double)cb0y + (double)i * twoppy), (int)twoppx, (int)twoppy, prg_ulx, prg_uly, prg_w, prg_h);
                if (r == 0) {
                    acb0x = cb0x;
                    acb0y = cb0y;
                    p0x = acb0x + j * (int)twoppx;
                    p1x = p0x + (int)twoppx;
                    p0y = acb0y + i * (int)twoppy;
                    p1y = p0y + (int)twoppy;
                    sb = (SubbandAn)root.getSubbandByIdx(0, 0);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[0] = 0;
                        this.ttIncl[t][c][r][nPrec][0] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][0] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][0] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][0] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[0] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[0] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                this.ppinfo[t][c][r][nPrec].cblk[0][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                                ++l;
                            }
                            ++k;
                        }
                    }
                } else {
                    acb0x = 0;
                    acb0y = cb0y;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandAn)root.getSubbandByIdx(r, 1);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[1] = 0;
                        this.ttIncl[t][c][r][nPrec][1] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][1] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][1] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][1] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[1] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[1] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                this.ppinfo[t][c][r][nPrec].cblk[1][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                                ++l;
                            }
                            ++k;
                        }
                    }
                    acb0x = cb0x;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandAn)root.getSubbandByIdx(r, 2);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[2] = 0;
                        this.ttIncl[t][c][r][nPrec][2] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][2] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][2] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][2] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[2] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[2] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                this.ppinfo[t][c][r][nPrec].cblk[2][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                                ++l;
                            }
                            ++k;
                        }
                    }
                    acb0x = 0;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandAn)root.getSubbandByIdx(r, 3);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[3] = 0;
                        this.ttIncl[t][c][r][nPrec][3] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][3] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][3] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][3] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[3] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[3] = (kend - kstart + 1) * (lend - lstart + 1);
                        k = kstart;
                        while (k <= kend) {
                            l = lstart;
                            while (l <= lend) {
                                this.ppinfo[t][c][r][nPrec].cblk[3][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                                ++l;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
                ++nPrec;
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BitOutputBuffer encodePacket(int ly, int c, int r, int t, CBlkRateDistStats[][] cbs, int[][] tIndx, BitOutputBuffer hbuf, byte[] bbuf, int pIdx) {
        int cblen;
        int n;
        int m;
        int b;
        int nend;
        int mend;
        int[] cur_tIndx;
        CBlkRateDistStats[] cur_cbs;
        int[] cur_prevtIdxs;
        SubbandAn sb;
        int minsb = r == 0 ? 0 : 1;
        int maxsb = r == 0 ? 1 : 4;
        Point cbCoord = null;
        SubbandAn root = this.infoSrc.getAnSubbandTree(t, c);
        this.roiInPkt = false;
        this.roiLen = 0;
        if (pIdx >= this.ppinfo[t][c][r].length) {
            this.packetWritable = false;
            return hbuf;
        }
        PrecInfo prec = this.ppinfo[t][c][r][pIdx];
        boolean isPrecVoid = true;
        int s = minsb;
        while (s < maxsb) {
            if (prec.nblk[s] != 0) {
                isPrecVoid = false;
                break;
            }
            ++s;
        }
        if (isPrecVoid) {
            this.packetWritable = true;
            if (hbuf == null) {
                hbuf = new BitOutputBuffer();
            } else {
                hbuf.reset();
            }
            if (bbuf == null) {
                bbuf = new byte[1];
                this.lbbuf = bbuf;
            }
            hbuf.writeBit(0);
            this.lblen = 0;
            return hbuf;
        }
        if (hbuf == null) {
            hbuf = new BitOutputBuffer();
        } else {
            hbuf.reset();
        }
        this.lbbuf = null;
        this.lblen = 0;
        hbuf.writeBit(1);
        int s2 = minsb;
        while (s2 < maxsb) {
            sb = (SubbandAn)root.getSubbandByIdx(r, s2);
            if (prec.nblk[s2] != 0) {
                TagTreeEncoder cur_ttIncl = this.ttIncl[t][c][r][pIdx][s2];
                TagTreeEncoder cur_ttMaxBP = this.ttMaxBP[t][c][r][pIdx][s2];
                cur_prevtIdxs = this.prevtIdxs[t][c][r][s2];
                cur_cbs = cbs[s2];
                cur_tIndx = tIndx[s2];
                mend = prec.cblk[s2] == null ? 0 : prec.cblk[s2].length;
                int m2 = 0;
                while (m2 < mend) {
                    nend = prec.cblk[s2][m2] == null ? 0 : prec.cblk[s2][m2].length;
                    int n2 = 0;
                    while (n2 < nend) {
                        cbCoord = prec.cblk[s2][m2][n2].idx;
                        b = cbCoord.x + cbCoord.y * sb.numCb.x;
                        if (cur_tIndx[b] > cur_prevtIdxs[b] && cur_prevtIdxs[b] < 0) {
                            cur_ttIncl.setValue(m2, n2, ly - 1);
                        }
                        if (ly == 1) {
                            cur_ttMaxBP.setValue(m2, n2, cur_cbs[b].skipMSBP);
                        }
                        ++n2;
                    }
                    ++m2;
                }
                m = 0;
                while (m < prec.cblk[s2].length) {
                    n = 0;
                    while (n < prec.cblk[s2][m].length) {
                        cbCoord = prec.cblk[s2][m][n].idx;
                        b = cbCoord.x + cbCoord.y * sb.numCb.x;
                        if (cur_tIndx[b] <= cur_prevtIdxs[b]) {
                            if (cur_prevtIdxs[b] >= 0) {
                                hbuf.writeBit(0);
                            } else {
                                cur_ttIncl.encode(m, n, ly, hbuf);
                            }
                        } else {
                            int nbits;
                            int j;
                            int prednbits;
                            int i;
                            if (cur_prevtIdxs[b] < 0) {
                                cur_ttIncl.encode(m, n, ly, hbuf);
                                int thmax = cur_cbs[b].skipMSBP + 1;
                                i = 1;
                                while (i <= thmax) {
                                    cur_ttMaxBP.encode(m, n, i, hbuf);
                                    ++i;
                                }
                                this.lblen += cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]];
                            } else {
                                hbuf.writeBit(1);
                                this.lblen += cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]] - cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                            }
                            int newtp = cur_prevtIdxs[b] < 0 ? cur_cbs[b].truncIdxs[cur_tIndx[b]] : cur_cbs[b].truncIdxs[cur_tIndx[b]] - cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] - 1;
                            switch (newtp) {
                                case 0: {
                                    hbuf.writeBit(0);
                                    break;
                                }
                                case 1: {
                                    hbuf.writeBits(2, 2);
                                    break;
                                }
                                case 2: 
                                case 3: 
                                case 4: {
                                    hbuf.writeBits(0xC | newtp - 2, 4);
                                    break;
                                }
                                default: {
                                    if (newtp <= 35) {
                                        hbuf.writeBits(0x1E0 | newtp - 5, 9);
                                    } else {
                                        if (newtp > 163) throw new ArithmeticException("Maximum number of truncation points exceeded");
                                        hbuf.writeBits(0xFF80 | newtp - 36, 16);
                                    }
                                }
                            }
                            newtp = 1;
                            int maxi = cur_cbs[b].truncIdxs[cur_tIndx[b]];
                            cblen = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                            i = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] + 1;
                            int minbits = 0;
                            while (i < maxi) {
                                if (cur_cbs[b].isTermPass != null && cur_cbs[b].isTermPass[i]) {
                                    cblen = cur_cbs[b].truncRates[i] - cblen;
                                    prednbits = this.lblock[t][c][r][s2][b] + MathUtil.log2(newtp);
                                    minbits = (cblen > 0 ? MathUtil.log2(cblen) : 0) + 1;
                                    j = prednbits;
                                    while (j < minbits) {
                                        int[] nArray = this.lblock[t][c][r][s2];
                                        int n3 = b;
                                        nArray[n3] = nArray[n3] + 1;
                                        hbuf.writeBit(1);
                                        ++j;
                                    }
                                    newtp = 0;
                                    cblen = cur_cbs[b].truncRates[i];
                                }
                                ++i;
                                ++newtp;
                            }
                            cblen = cur_cbs[b].truncRates[i] - cblen;
                            prednbits = this.lblock[t][c][r][s2][b] + MathUtil.log2(newtp);
                            minbits = (cblen > 0 ? MathUtil.log2(cblen) : 0) + 1;
                            j = prednbits;
                            while (j < minbits) {
                                int[] nArray = this.lblock[t][c][r][s2];
                                int n4 = b;
                                nArray[n4] = nArray[n4] + 1;
                                hbuf.writeBit(1);
                                ++j;
                            }
                            hbuf.writeBit(0);
                            newtp = 1;
                            maxi = cur_cbs[b].truncIdxs[cur_tIndx[b]];
                            cblen = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                            i = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] + 1;
                            while (i < maxi) {
                                if (cur_cbs[b].isTermPass != null && cur_cbs[b].isTermPass[i]) {
                                    cblen = cur_cbs[b].truncRates[i] - cblen;
                                    nbits = MathUtil.log2(newtp) + this.lblock[t][c][r][s2][b];
                                    hbuf.writeBits(cblen, nbits);
                                    newtp = 0;
                                    cblen = cur_cbs[b].truncRates[i];
                                }
                                ++i;
                                ++newtp;
                            }
                            cblen = cur_cbs[b].truncRates[i] - cblen;
                            nbits = MathUtil.log2(newtp) + this.lblock[t][c][r][s2][b];
                            hbuf.writeBits(cblen, nbits);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++s2;
        }
        if (bbuf == null || bbuf.length < this.lblen) {
            bbuf = new byte[this.lblen];
        }
        this.lbbuf = bbuf;
        this.lblen = 0;
        int s3 = minsb;
        while (s3 < maxsb) {
            sb = (SubbandAn)root.getSubbandByIdx(r, s3);
            cur_prevtIdxs = this.prevtIdxs[t][c][r][s3];
            cur_cbs = cbs[s3];
            cur_tIndx = tIndx[s3];
            int ncb = cur_prevtIdxs.length;
            mend = prec.cblk[s3] == null ? 0 : prec.cblk[s3].length;
            m = 0;
            while (m < mend) {
                nend = prec.cblk[s3][m] == null ? 0 : prec.cblk[s3][m].length;
                n = 0;
                while (n < nend) {
                    cbCoord = prec.cblk[s3][m][n].idx;
                    b = cbCoord.x + cbCoord.y * sb.numCb.x;
                    if (cur_tIndx[b] > cur_prevtIdxs[b]) {
                        if (cur_prevtIdxs[b] < 0) {
                            cblen = cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]];
                            System.arraycopy(cur_cbs[b].data, 0, this.lbbuf, this.lblen, cblen);
                        } else {
                            cblen = cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]] - cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                            System.arraycopy(cur_cbs[b].data, cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]], this.lbbuf, this.lblen, cblen);
                        }
                        this.lblen += cblen;
                        if (cur_cbs[b].nROIcoeff != 0 && (cur_prevtIdxs[b] == -1 || cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] <= cur_cbs[b].nROIcp - 1)) {
                            this.roiInPkt = true;
                            this.roiLen = this.lblen;
                        }
                        cur_prevtIdxs[b] = cur_tIndx[b];
                    }
                    ++n;
                }
                ++m;
            }
            ++s3;
        }
        this.packetWritable = true;
        if (hbuf.getLength() != 0) return hbuf;
        throw new Error("You have found a bug in PktEncoder, method: encodePacket");
    }

    public byte[] getLastBodyBuf() {
        if (this.lbbuf == null) {
            throw new IllegalArgumentException();
        }
        return this.lbbuf;
    }

    public int getLastBodyLen() {
        return this.lblen;
    }

    public void save() {
        int maxsbi;
        int minsbi;
        if (this.bak_lblock == null) {
            this.bak_lblock = new int[this.ttIncl.length][][][][];
            this.bak_prevtIdxs = new int[this.ttIncl.length][][][][];
            int t = this.ttIncl.length - 1;
            while (t >= 0) {
                this.bak_lblock[t] = new int[this.ttIncl[t].length][][][];
                this.bak_prevtIdxs[t] = new int[this.ttIncl[t].length][][][];
                int c = this.ttIncl[t].length - 1;
                while (c >= 0) {
                    this.bak_lblock[t][c] = new int[this.lblock[t][c].length][][];
                    this.bak_prevtIdxs[t][c] = new int[this.ttIncl[t][c].length][][];
                    int r = this.lblock[t][c].length - 1;
                    while (r >= 0) {
                        this.bak_lblock[t][c][r] = new int[this.lblock[t][c][r].length][];
                        this.bak_prevtIdxs[t][c][r] = new int[this.prevtIdxs[t][c][r].length][];
                        minsbi = r == 0 ? 0 : 1;
                        maxsbi = r == 0 ? 1 : 4;
                        int s = minsbi;
                        while (s < maxsbi) {
                            this.bak_lblock[t][c][r][s] = new int[this.lblock[t][c][r][s].length];
                            this.bak_prevtIdxs[t][c][r][s] = new int[this.prevtIdxs[t][c][r][s].length];
                            ++s;
                        }
                        --r;
                    }
                    --c;
                }
                --t;
            }
        }
        int t = this.ttIncl.length - 1;
        while (t >= 0) {
            int c = this.ttIncl[t].length - 1;
            while (c >= 0) {
                int[][][] lblock_t_c = this.lblock[t][c];
                int[][][] bak_lblock_t_c = this.bak_lblock[t][c];
                TagTreeEncoder[][][] ttIncl_t_c = this.ttIncl[t][c];
                TagTreeEncoder[][][] ttMaxBP_t_c = this.ttMaxBP[t][c];
                int r = lblock_t_c.length - 1;
                while (r >= 0) {
                    TagTreeEncoder[][] ttIncl_t_c_r = ttIncl_t_c[r];
                    TagTreeEncoder[][] ttMaxBP_t_c_r = ttMaxBP_t_c[r];
                    int[][] prevtIdxs_t_c_r = this.prevtIdxs[t][c][r];
                    int[][] bak_prevtIdxs_t_c_r = this.bak_prevtIdxs[t][c][r];
                    minsbi = r == 0 ? 0 : 1;
                    maxsbi = r == 0 ? 1 : 4;
                    int s = minsbi;
                    while (s < maxsbi) {
                        System.arraycopy(lblock_t_c[r][s], 0, bak_lblock_t_c[r][s], 0, lblock_t_c[r][s].length);
                        System.arraycopy(prevtIdxs_t_c_r[s], 0, bak_prevtIdxs_t_c_r[s], 0, prevtIdxs_t_c_r[s].length);
                        ++s;
                    }
                    int p = this.ppinfo[t][c][r].length - 1;
                    while (p >= 0) {
                        if (p < ttIncl_t_c_r.length) {
                            int s2 = minsbi;
                            while (s2 < maxsbi) {
                                ttIncl_t_c_r[p][s2].save();
                                ttMaxBP_t_c_r[p][s2].save();
                                ++s2;
                            }
                        }
                        --p;
                    }
                    --r;
                }
                --c;
            }
            --t;
        }
        this.saved = true;
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        this.lbbuf = null;
        int t = this.ttIncl.length - 1;
        while (t >= 0) {
            int c = this.ttIncl[t].length - 1;
            while (c >= 0) {
                int[][][] lblock_t_c = this.lblock[t][c];
                int[][][] bak_lblock_t_c = this.bak_lblock[t][c];
                TagTreeEncoder[][][] ttIncl_t_c = this.ttIncl[t][c];
                TagTreeEncoder[][][] ttMaxBP_t_c = this.ttMaxBP[t][c];
                int r = lblock_t_c.length - 1;
                while (r >= 0) {
                    TagTreeEncoder[][] ttIncl_t_c_r = ttIncl_t_c[r];
                    TagTreeEncoder[][] ttMaxBP_t_c_r = ttMaxBP_t_c[r];
                    int[][] prevtIdxs_t_c_r = this.prevtIdxs[t][c][r];
                    int[][] bak_prevtIdxs_t_c_r = this.bak_prevtIdxs[t][c][r];
                    int minsbi = r == 0 ? 0 : 1;
                    int maxsbi = r == 0 ? 1 : 4;
                    int s = minsbi;
                    while (s < maxsbi) {
                        System.arraycopy(bak_lblock_t_c[r][s], 0, lblock_t_c[r][s], 0, lblock_t_c[r][s].length);
                        System.arraycopy(bak_prevtIdxs_t_c_r[s], 0, prevtIdxs_t_c_r[s], 0, prevtIdxs_t_c_r[s].length);
                        ++s;
                    }
                    int p = this.ppinfo[t][c][r].length - 1;
                    while (p >= 0) {
                        if (p < ttIncl_t_c_r.length) {
                            int s2 = minsbi;
                            while (s2 < maxsbi) {
                                ttIncl_t_c_r[p][s2].restore();
                                ttMaxBP_t_c_r[p][s2].restore();
                                ++s2;
                            }
                        }
                        --p;
                    }
                    --r;
                }
                --c;
            }
            --t;
        }
    }

    public void reset() {
        this.saved = false;
        this.lbbuf = null;
        int t = this.ttIncl.length - 1;
        while (t >= 0) {
            int c = this.ttIncl[t].length - 1;
            while (c >= 0) {
                int[][][] lblock_t_c = this.lblock[t][c];
                TagTreeEncoder[][][] ttIncl_t_c = this.ttIncl[t][c];
                TagTreeEncoder[][][] ttMaxBP_t_c = this.ttMaxBP[t][c];
                int r = lblock_t_c.length - 1;
                while (r >= 0) {
                    TagTreeEncoder[][] ttIncl_t_c_r = ttIncl_t_c[r];
                    TagTreeEncoder[][] ttMaxBP_t_c_r = ttMaxBP_t_c[r];
                    int[][] prevtIdxs_t_c_r = this.prevtIdxs[t][c][r];
                    int minsbi = r == 0 ? 0 : 1;
                    int maxsbi = r == 0 ? 1 : 4;
                    int s = minsbi;
                    while (s < maxsbi) {
                        ArrayUtil.intArraySet(prevtIdxs_t_c_r[s], -1);
                        ArrayUtil.intArraySet(lblock_t_c[r][s], 3);
                        ++s;
                    }
                    int p = this.ppinfo[t][c][r].length - 1;
                    while (p >= 0) {
                        if (p < ttIncl_t_c_r.length) {
                            int s2 = minsbi;
                            while (s2 < maxsbi) {
                                ttIncl_t_c_r[p][s2].reset();
                                ttMaxBP_t_c_r[p][s2].reset();
                                ++s2;
                            }
                        }
                        --p;
                    }
                    --r;
                }
                --c;
            }
            --t;
        }
    }

    public boolean isPacketWritable() {
        return this.packetWritable;
    }

    public boolean isROIinPkt() {
        return this.roiInPkt;
    }

    public int getROILen() {
        return this.roiLen;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public PrecInfo getPrecInfo(int t, int c, int r, int p) {
        return this.ppinfo[t][c][r][p];
    }

    static {
        OPT_PREFIX = (char)80;
        pinfo = new String[][]{{"Psop", "[<tile idx>] true|false[ [<tile idx>] true|false ...]", "Specifies whether start of packet (SOP) markers should be used. 'true' enables, 'false' disables it.", "false"}, {"Peph", "[<tile idx>] true|false[ [<tile  idx>] true|false ...]", "Specifies whether end of packet header (EPH) markers should be  used. 'true' enables, 'false' disables it.", "false"}};
        INIT_LBLOCK = 3;
    }
}

