/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.client.algorithms.parameters;

import java.awt.Window;

import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;

/**
 * Viso para o {@link DoubleListParameter Parmetro Tipo Lista de Reais}.
 *
 * @author lmoreira
 */
public final class DoubleListParameterView extends ListParameterView<Double> {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   *
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   *
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public DoubleListParameterView(Window window, DoubleListParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   *
   * @param parameter O parmetro que  manipulado por esta viso (No aceita
   *        {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public DoubleListParameterView(DoubleListParameter parameter, Mode mode) {
    super(parameter, mode, new Parser<Double>() {
      @Override
      public Double parse(String text) {
        try {
          return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
          return null;
        }
      }
    }, new Formatter<Double>() {
      @Override
      public String format(Double element) {
        return element.toString();
      }
    }, new DoubleTextField(DoubleParameter.ERROR_VALUE));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DoubleListParameter getParameter() {
    return (DoubleListParameter) super.getParameter();
  }

}
