package csbase.client.applications.algorithmsmanager.models;

import java.util.SortedSet;

import csbase.logic.algorithms.Category;

/**
 * Interface que modela os dados dos ns de uma rvore para gerncia de
 * categorias de algoritmos.
 * 
 */
public interface CategoryNodeInterface extends DataInterface {

  /**
   * Obtm os sub-ns de um n, que sejam do mesmo tipo do n. O conjunto
   * retornado  imutvel. Caso no haja ns filhos, retornar um conjunto
   * vazio.
   * 
   * @return os sub-ns de um n ou um conjunto vazio
   */
  public SortedSet<Category> getSubNodes();

  /**
   * Compara um n com outro n especificado, segundo algum critrio definido
   * pelo n.
   * 
   * @param node n a ser comparado
   * 
   * @return o resultado da comparao entre os ns
   */
  public int compare(Category node);

  /**
   * Obtm o n representado por uma categoria.
   * 
   * @return o n categoria, caso contrrio, retorna null
   */
  public Category getNode();

  /**
   * Verifica se  o n raiz da rvore de categorias.
   * 
   * @return retorna true se for o n raiz da rvore de categorias, caso
   *         contrrio, retorna false
   */
  public boolean isRootNode();
}
