package csbase.client.applications.algorithmsmanager.versiontree;

import java.util.Vector;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.dialogs.VersionTreeView;
import csbase.client.applications.algorithmsmanager.models.AbstractVersionTreeNode;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Representa o n raiz da rvore de verses do algoritmo, que efetivamente
 * constri a rvore a partir das verses do algoritmo.
 * 
 */
public final class VersionTreeRootNode extends AbstractVersionTreeNode
  implements VersionNodeInterface {
  /** Todos as verses do algoritmo */
  private Vector<AlgorithmVersionInfo> allNodes;

  /**
   * Constri a rvore de verses do algoritmo a partir do n raiz.
   * 
   * @param tree rvore que contm esse n
   * 
   * @param versions verses do algoritmo
   */
  public VersionTreeRootNode(VersionTree tree,
    Vector<AlgorithmVersionInfo> versions) {
    super(tree, VersionTreeView.ROOT_NAME);
    this.allNodes = versions;
    if (versions != null) {
      for (AlgorithmVersionInfo algoVersion : allNodes) {
        add(new VersionTreeNode(tree, algoVersion));
      }
    }
  }

  @Override
  public int compare(AlgorithmVersionInfo node) {
    return 0;
  }

  @Override
  public AlgorithmVersionInfo getNode() {
    return null;
  }

  @Override
  public AlgorithmVersionId getId() {
    return null;
  }

  @Override
  public boolean isRootNode() {
    return true;
  }

  @Override
  public ImageIcon getImageIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * Obtm o ndice do n representando o algoritmo especificado.
   * 
   * @param algoId identificador do algoritmo sendo buscado.
   * 
   * @return o ndice do n ou -1 se este no for encontrado.
   */
  public int getNodeIndex(Object algoId) {
    if (children != null) {
      for (int i = 0; i < children.size(); i++) {
        VersionTreeNode childNode = (VersionTreeNode) children.get(i);
        AlgorithmVersionInfo childAlgoInfo = (AlgorithmVersionInfo) childNode
          .getUserObject();
        Object childAlgoId = childAlgoInfo.getId();
        if (algoId.equals(childAlgoId)) {
          return i;
        }
      }
    }
    return -1;
  }
}