package csbase.client.applications.flowapplication.graph;

import java.awt.Font;
import java.awt.Graphics2D;

import tecgraf.vix.TypeVS;

/**
 * Vo de texto que pode ser ocultado dinamicamente.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class HideableGraphString extends GraphString {

  /** Indica se o texto deve estar visvel. */
  private boolean isVisible;

  /**
   * Construtor.
   * 
   * @param vs o vs.
   * @param text o texto.
   * @param isVisible indica se o texto deve estar visvel.
   */
  public HideableGraphString(TypeVS vs, String text, boolean isVisible) {
    super(vs, text);
    this.isVisible = isVisible;
  }

  /**
   * Construtor.
   * 
   * @param vs o vs.
   * @param text o texto.
   * @param font a fonte do texto.
   * @param isVisible indica se o texto deve estar visvel.
   */
  public HideableGraphString(final TypeVS vs, final String text,
    final Font font, boolean isVisible) {
    super(vs, text, font);
    this.isVisible = isVisible;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackRepaint(Graphics2D g) {
    if (isVisible()) {
      super.callbackRepaint(g);
    }
  }

  /**
   * Indica se o texto est visvel.
   * 
   * @return verdadeiro se o texto est sendo mostrado ou falso, caso contrrio.
   */
  protected boolean isVisible() {
    return isVisible;
  }

  /**
   * Determina se o texto est visvel.
   * 
   * @param isVisible verdadeiro se o texto deve ser mostrado ou falso, caso
   *        contrrio.
   */
  protected void setVisible(boolean isVisible) {
    this.isVisible = isVisible;
  }
}
