/*
 * $Id: ImageViewerOpenAction.java 146656 2013-11-07 17:13:39Z mjulia $
 */
package csbase.client.applications.imageviewer.actions.io;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.logic.ClientProjectFile;

/**
 * Ao de abrir arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ImageViewerOpenAction extends ImageViewerAction {

  /**
   * {@inheritDoc}
   */
  @Override
  protected ImageIcon getDefaultIcon() {
    return ApplicationImages.ICON_OPEN_16;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public ImageViewerOpenAction(ImageViewer application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) {
    final ImageViewer application = getApplication();
    List<String> fileCodes = application.getFileTypes();
    if (fileCodes == null) {
      fileCodes = new ArrayList<String>();
    }

    final ClientProjectFileChooserUtil.OperationResult result =
      ClientProjectFileChooserUtil.browseSingleFileInOpenMode(application,
        fileCodes, true);
    if (result == null) {
      return;
    }
    final ClientProjectFile newFile = result.getClientProjectFile();
    final boolean opened = application.openFile(newFile);
    if (!opened) {
      if (newFile.size() == 0) {
        final String msg = getString("ImageViewerOpenAction.zero.size.tip");
        application.showInformation(msg);
      }
      return;
    }

    application.setCurrentFile(newFile);
  }
}
