/**
 * $Id: ClientProjectFileDirectoryFilter.java 109596 2010-08-27 22:46:16Z clinio
 * $
 */
package csbase.client.util.filechooser.filters;

import javax.swing.ImageIcon;

import csbase.client.project.ClientProjectFileType;
import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;

/**
 * Filtro com base no nipo do arquivo.
 * 
 * @author Tecgraf
 */
public class ClientFileDirectoryFilter implements ClientFileFilterInterface {

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean accept(ClientFile file) {
    if (file.isDirectory()) {
      return true;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    final String type = ProjectFileType.DIRECTORY_TYPE;
    ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
    final String desc = fileType.getDescription();
    return desc;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    final String type = ProjectFileType.DIRECTORY_TYPE;
    ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
    return fileType.getBaseIcon();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectFileType inferFileType() {
    return null;
  }
}
