package csbase.client.util.table;

import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * Modelo de Clula Abstrato: esta classe contm implementaes para alguns
 * mtodos da interface {@link CellModel}, portanto ela facilita a
 * implementao da interface {@link CellModel}.
 * </p>
 */
public abstract class AbstractCellModel implements CellModel {

  /**
   * Os observadores.
   */
  private List<CellModelListener> listeners;

  /**
   * Cria um modelo abstrato.
   */
  protected AbstractCellModel() {
    this.listeners = new LinkedList<CellModelListener>();
  }

  public final void addCellModelListener(CellModelListener listener) {
    if (listener == null) {
      throw new IllegalArgumentException("O parmetro listener est nulo.");
    }
    this.listeners.add(listener);
  }

  public final void removeCellModelListener(CellModelListener listener) {
    if (listener == null) {
      throw new IllegalArgumentException("O parmetro listener est nulo.");
    }

    this.listeners.remove(listener);
  }

  public final boolean setValue(Object value) {
    Object currentValue = getValue();
    if (value == null) {
      if (currentValue == null) {
        return false;
      }
    }
    else if (value.equals(currentValue)) {
      return false;
    }
    keepValue(value);
    fireValueWasChanged();
    return true;
  }

  /**
   * <p>
   * Armazena o valor no modelo.
   * </p>
   * 
   * <p>
   * No gera evento.
   * </p>
   * 
   * @param value O valor (Aceita {@code null}).
   */
  protected abstract void keepValue(Object value);

  /**
   * Dispara o evento {@link CellModelListener#valueWasChanged(CellModel)}.
   */
  private final void fireValueWasChanged() {
    for (CellModelListener listener : listeners) {
      listener.valueWasChanged(this);
    }
  }
}
