package csbase.client.util.table;

import java.util.ArrayList;
import java.util.List;

/**
 * Fbria de {@link ComboBoxCellView Clulas de ComboBoxes}: cria clulas de
 * <i>comboboxes</i>.
 */
public final class ComboBoxCellViewFactory implements CellViewFactory {

  /**
   * Os tens disponveis para seleo.
   */
  private List<ComboBoxCellViewItem> availableItems;

  /**
   * Cria a fbrica.
   * 
   * @param items Os tens disponveis para seleo. (No aceita {@code null} e
   *        no pode ser vazio).
   */
  public ComboBoxCellViewFactory(List<ComboBoxCellViewItem> items) {
    setAvailableItems(items);
  }

  public ComboBoxCellView create() {
    return new ComboBoxCellView(availableItems);
  }

  /**
   * Atribui os tens disponveis para seleo nesta clula.
   * 
   * @param items Os tens disponveis (No aceita {@code null} e no pode estar
   *        vazio).
   */
  private void setAvailableItems(List<ComboBoxCellViewItem> items) {
    if (items == null) {
      throw new IllegalArgumentException("O parmetro items est nulo.");
    }
    if (items.isEmpty()) {
      throw new IllegalArgumentException("O parmetro items est vazio.");
    }
    availableItems = new ArrayList<ComboBoxCellViewItem>(items);
  }
}
