/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode;
import csbase.client.applications.algorithmsmanager.versiontree.AbstractVersionTreeNode;
import csbase.client.applications.algorithmsmanager.versiontree.DocumentationFileNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ImportDocumentationFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableTarget;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.DocumentationPathFactory;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tecgraf.javautils.core.lng.LNG;

final class DocumentationNode
extends AbstractVersionTreeNode
implements ITransferableTarget {
    private AlgorithmVersionInfo version;

    public DocumentationNode(VersionTree tree, AlgorithmVersionInfo version) {
        super(tree, version.getDocumentationDirName());
        this.version = version;
        for (FileInfo file : version.getDocumentation()) {
            this.add(new DocumentationFileNode(tree, version, file));
        }
    }

    @Override
    public ImageIcon getImageIcon() {
        return ApplicationImages.ICON_FOLDER_16;
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ImportDocumentationFile(this.getTree(), this.version))));
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new PasteFile(this.getTree(), LNG.get((String)"algomanager.menu.doc.paste"), DocumentationFileNode.DATA_FLAVOR))));
        return popupMenu;
    }

    @Override
    public boolean canImport(Object[] data, DataFlavor flavor) {
        return null != data && 0 < data.length && DocumentationFileNode.DATA_FLAVOR.equals(flavor);
    }

    @Override
    public boolean importData(Object[] data) {
        AbstractFileInfoNode.DataTransferObject dto = (AbstractFileInfoNode.DataTransferObject)data[0];
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        ArrayList<FileInfo> files = new ArrayList<FileInfo>(data.length);
        for (Object obj : data) {
            dto = (AbstractFileInfoNode.DataTransferObject)obj;
            FileInfo file = dto.getFile();
            files.add(file);
        }
        DocumentationPathFactory sourcePathFactory = new DocumentationPathFactory(sourceVersion);
        DocumentationPathFactory targetPathFactory = new DocumentationPathFactory(this.version);
        AlgorithmManagementProxy.copyFiles(sourceVersion, files, (IPathFactory)sourcePathFactory, this.version, null, (IPathFactory)targetPathFactory, false, this.getWindow());
        return true;
    }
}

