/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.remote.ClientProjectObserver;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectObserver;
import csbase.logic.Session;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import tecgraf.javautils.core.lng.LNG;

public abstract class ProjectAction
extends AbstractAction
implements ClipboardOwner {
    private ProjectTree treeView;

    public Window getWindow() {
        return this.treeView.getWindow();
    }

    public String getTitle() {
        return this.treeView.getTitle();
    }

    public ProjectTree getProjectTree() {
        return this.treeView;
    }

    public CommonClientProject getCurrentProject() {
        return this.treeView.getProject();
    }

    public void setCurrentProject(CommonClientProject project) throws Exception {
        if (project == null) {
            return;
        }
        CommonClientProject currentProject = this.getCurrentProject();
        if (currentProject != null) {
            currentProject.uninstallObserver();
        }
        project.installObserver((ProjectObserver)new ClientProjectObserver(project));
        this.treeView.setProject(project);
        this.setProjectSessionProperty(project);
    }

    private void setProjectSessionProperty(final CommonClientProject project) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                ClientServerManager clientServerManager = ClientServerManager.getInstance();
                Session session = clientServerManager.getSession();
                Object key = session.getKey();
                Object userId = project.getUserId();
                Object projectId = project.getId();
                String projectName = project.getName();
                ClientRemoteLocator.server.setServerSessionProperty(key, "current_project", (Serializable)new UserProjectInfo(projectId, projectName, userId));
            }
        };
        task.execute(DesktopFrame.getInstance().getView(), this.getTitle(), LNG.get((String)"ProjectAction.current.session.project.property"));
    }

    public void closeProject() {
        this.treeView.closeProject();
        try {
            this.getCurrentProject().uninstallObserver();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ClientProjectFile getSelectedFile() {
        return this.treeView.getSelectedFile();
    }

    public ClientProjectFile[] getSelectedFiles() {
        return this.treeView.getSelectedFiles();
    }

    public void clearClipboard() {
        this.treeView.clearClipboard();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void enableIfProjectOpened() {
        this.treeView.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                ProjectAction.this.setEnabled(project != null);
            }
        });
    }

    public void enableIfProject() {
        this.treeView.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectRemoved() {
                ProjectAction.this.setEnabled(DesktopFrame.getInstance().userHasProject());
            }
        });
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public abstract String getName();

    public ProjectAction(ProjectTree treeView) {
        this.treeView = treeView;
        this.putValue("Name", this.getName());
    }
}

