/**
 * $Id: OutputFileParameterView.java 167814 2015-08-28 15:50:27Z analodi $
 */

package csbase.client.algorithms.parameters;

import java.awt.Window;
import java.text.MessageFormat;

import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectDirectoryChooser;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectFileChooserSave;
import csbase.client.project.ProjectTreePath;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.FileURLValue;

/**
 * A Viso para {@link OutputFileParameter Parmetro do Tipo Arquivo de Sada}.
 *
 * @author lmoreira
 */
public final class OutputFileParameterView extends FileParameterView {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   *
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   *
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public OutputFileParameterView(Window window, OutputFileParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   *
   * @param parameter O parmetro (No aceita {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public OutputFileParameterView(OutputFileParameter parameter, Mode mode) {
    super(parameter, mode);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public OutputFileParameter getParameter() {
    return (OutputFileParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected FileURLValue askForFile() {
    try {
      if (FileParameterMode.REGULAR_FILE.equals(getParameter().getMode())) {
        ProjectFileChooserSave chooser =
          new ProjectFileChooserSave(getWindow(), DesktopFrame.getInstance()
            .getProject(), ProjectFileChooser.FILE_ONLY, getParameter()
            .getFileType(), null, null, getParameter().usesFilter());
        ProjectTreePath projectTreePath = chooser.getSelectedPath();
        if (projectTreePath == null) {
          return null;
        }
        ClientProjectFile clientProjectFile = projectTreePath.getFile();
        String type;
        if (clientProjectFile == null) {
          type = getParameter().getFileType();
        }
        else if (clientProjectFile.isDirectory()) {
          type = ProjectFileType.DIRECTORY_TYPE;
        }
        else {
          type = clientProjectFile.getType();
        }
        String path = FileUtils.joinPath('/', projectTreePath.getPath());
        return new FileURLValue(path, type);
      }
      if (FileParameterMode.DIRECTORY.equals(getParameter().getMode())) {
        ProjectDirectoryChooser chooser =
          new ProjectDirectoryChooser(DesktopFrame.getInstance().getProject(),
            getWindow());
        ProjectTreePath projectTreePath = chooser.getSelectedDirectory();
        if (projectTreePath == null) {
          return null;
        }
        return new FileURLValue(FileUtils.joinPath('/', projectTreePath.getPath()),
          ProjectFileType.DIRECTORY_TYPE);
      }
      String errorMessage =
        MessageFormat.format("O modo de operao {0} no  suportado.",
          getParameter().getMode());
      throw new IllegalStateException(errorMessage);
    }
    catch (ClientException e) {
      String errorMessage =
        "Ocorreu um erro ao abrir o dilogo de seleo de arquivos.";
      if (e.getLocalizedMessage() != null) {
        errorMessage += "\nDetalhes:\n";
        errorMessage += e.getLocalizedMessage();
      }
      StandardDialogs.showErrorDialog(getWindow(),
        "Erro ao abrir o dilogo de seleo de arquivo", errorMessage);
      return null;
    }
  }

}
