/*
 * $Id: ApplicationFrame.java 142642 2013-07-15 19:51:43Z isabella $
 */

package csbase.client.applications;

import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerListener;
import csbase.client.desktop.DesktopComponentFrame;

/**
 * Janela de uma aplicao
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationFrame extends DesktopComponentFrame implements
  ApplicationManagerListener {

  /**
   * Aplicao
   */
  final private Application application;

  /**
   * 
   */
  private String title = "";

  /**
   * Adiciona listsner no aplication-manager para atualizao da janela.
   */
  void addApplicationManagerListener() {
    if (showInstanceId()) {
      final ApplicationManager mng = ApplicationManager.getInstance();
      mng.addListener(this);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void applicationEnded(final String id) {
    updateTitle(id);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void applicationStarted(final String id) {
    updateTitle(id);
  }

  /**
   * Remove listsner no aplication-manager para atualizao da janela.
   */
  void delApplicationManagerListener() {
    if (showInstanceId()) {
      final ApplicationManager mng = ApplicationManager.getInstance();
      mng.delListener(this);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getTitle() {
    if (!showInstanceId()) {
      return super.getTitle();
    }

    return title;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public void setTitle(final String newTitle) {
    if (!showInstanceId()) {
      super.setTitle(newTitle);
      return;
    }

    // Por incrvel que parea application pode vir null
    // pois o construtor chama um super() que faz um setTitle().
    // :(
    if (application == null) {
      super.setTitle(newTitle);
      return;
    }
    final String t = (newTitle == null ? "" : newTitle);
    final int id = application.getInstanceIndex();
    super.setTitle(t + " -  [" + id + "]");
    this.title = t;
  }

  /**
   * Indica (com base no configuration manager) se as application frames deve
   * ter em seu ttulo um indentificador de instncia da aplicao.
   * 
   * @return um indicativo
   */
  private boolean showInstanceId() {
    try {
      final ConfigurationManager cnfManager =
        ConfigurationManager.getInstance();
      final Configuration cnf = cnfManager.getConfiguration(this.getClass());
      final boolean result =
        cnf.getOptionalBooleanProperty("show.instance.id", false);
      return result;
    }
    catch (final ConfigurationManagerException e) {
      return false;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void close() {
    delApplicationManagerListener();
    super.close();
  }

  /**
   * Atualizao de ttulo com base na instncia da aplicao.
   * 
   * @param id da aplicao que foi lanada/encerrada.
   */
  private void updateTitle(final String id) {
    if (application == null) {
      return;
    }
    final String myId = application.getId();
    if (myId.equals(id)) {
      setTitle(title);
    }
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   * @param id o identificador
   */
  public ApplicationFrame(final Application application, final String id) {
    super();
    this.application = application;
  }
}
