/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.events;

import csbase.client.util.event.IEvent;
import csbase.logic.CommandInfo;

/**
 * Evento lanado quando  alterada a seleo de comandos da aplicao.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class SelectionChangedEvent implements IEvent {

  /**
   * Comandos selecionados no momento em que este evento foi criado.
   */
  private CommandInfo[] selection;

  /**
   * Construtor de um evento indicando que os comandos perderam a seleo.<br>
   * Neste caso, {@link #getSelection()} retornar uma lista vazia.
   */
  public SelectionChangedEvent() {
    this(new CommandInfo[0]);
  }

  /**
   * Construtor.
   * 
   * @param selection Comandos selecionados no momento em que este evento foi
   *        criado.
   */
  public SelectionChangedEvent(CommandInfo[] selection) {
    this.selection = selection;
  }

  /**
   * Obtm os comandos selecionados no momento em que este evento foi criado.
   * 
   * @return um array contendo os comandos selecionados no momento em que este
   *         evento foi criado ou um array vazio indicando que no h comandos
   *         selecionados.
   */
  public CommandInfo[] getSelection() {
    return selection;
  }
}
