/*
 * $Id: HomeRemoteAction.java 92013 2009-05-30 01:42:13Z clinio $
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;
import csbase.logic.filetransferservice.FileTransferConnection;

/**
 * Ao de mudar diretrio remoto par o "home"
 * 
 * @author Tecgraf/PUC-Rio
 */
public class HomeRemoteAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientRemotePanel remotePanel = app.getRemotePanel();
    final FileTransferConnection connection = app.getConnection();
    if (connection == null) {
      return;
    }
    final String homePath = connection.getHomePath();
    if (homePath == null) {
      return;
    }
    remotePanel.setRemoteDirectory(homePath);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public HomeRemoteAction(final FileTransferClient application) {
    super(application);
  }

}
