/*
 * $Id: UpRemoteDirectoryAction.java 92013 2009-05-30 01:42:13Z clinio $
 */

/**
 * 
 */
package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;

/**
 * Ao de subir um diretrio remotamente.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class UpRemoteDirectoryAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientRemotePanel remotePanel = app.getRemotePanel();
    final String remoteDir = remotePanel.getRemoteDirectory();
    if (remotePanel.isRootDirectory(remoteDir))
      return;
    final String[] path = remoteDir.split("/");
    String newDir = "";
    for (int i = 0; i < path.length - 1; i++) {
      final String name = path[i];
      if (!FileTransferClientUI.isEmptyString(name)) {
        newDir = newDir + "/" + name;
      }
    }
    remotePanel.setRemoteDirectory(newDir);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public UpRemoteDirectoryAction(final FileTransferClient application) {
    super(application);
  }
}
